/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.forms;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.DeviceInfo;
import com.android.tools.idea.editors.gfxtrace.widgets.TextField;
import com.android.tools.idea.logcat.RegexFilterComponent;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivitySelector
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTree myTree;
    private JBLabel myStatus;
    private RegexFilterComponent mySearchBox;
    private TextField myTraceName;
    private DeviceInfo.Package mySelectedPackage;
    private DeviceInfo.Activity mySelectedActivity;
    private boolean myUserHasChangedTraceName = false;
    @NotNull
    private Listener myListener = NULL_LISTENER;
    private static final Listener NULL_LISTENER = new Listener(){

        @Override
        public void OnLaunch(DeviceInfo.Package pkg, DeviceInfo.Activity activity, String name) {
        }

        @Override
        public void OnCancel() {
        }
    };

    public ActivitySelector(DeviceInfo.Provider dip) {
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivitySelector.this.myListener.OnLaunch(ActivitySelector.this.mySelectedPackage, ActivitySelector.this.mySelectedActivity, ActivitySelector.this.myTraceName.getText().trim());
                ActivitySelector.this.dispose();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivitySelector.this.myListener.OnCancel();
                ActivitySelector.this.dispose();
            }
        });
        this.myTraceName.addChangedListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ActivitySelector.this.myUserHasChangedTraceName = !ActivitySelector.this.myTraceName.getText().isEmpty();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ActivitySelector.this.myListener.OnCancel();
                ActivitySelector.this.dispose();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivitySelector.this.myListener.OnCancel();
                ActivitySelector.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.myStatus.setText("Loading...");
        this.myTree.setVisible(false);
        this.buttonOK.setEnabled(false);
        final ListenableFuture<DeviceInfo> future = this.getDeviceInfo(dip);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                DeviceInfo deviceInfo = null;
                try {
                    deviceInfo = (DeviceInfo)future.get();
                }
                catch (Exception e) {
                    ActivitySelector.this.myStatus.setText("Error: " + e.getMessage());
                    return;
                }
                ActivitySelector.this.myStatus.setVisible(false);
                ActivitySelector.this.myTree.setModel(new DeviceTreeModel(ActivitySelector.this.mySearchBox, deviceInfo));
                ActivitySelector.this.myTree.setVisible(true);
                ActivitySelector.this.pack();
            }
        }, (Executor)EdtExecutor.INSTANCE);
        this.myTree.setRowHeight(20);
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/gfxtrace/forms/ActivitySelector$8", "customizeCellRenderer"));
                }
                Icon icon = null;
                if (value instanceof DeviceInfo.Package) {
                    DeviceInfo.Package pkg = (DeviceInfo.Package)value;
                    this.append(pkg.myName);
                    icon = pkg.myIcon;
                }
                if (value instanceof DeviceInfo.Activity) {
                    DeviceInfo.Activity act = (DeviceInfo.Activity)value;
                    if (act.myIsLaunch) {
                        this.append(act.myName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else {
                        this.append(act.myName);
                    }
                    icon = act.myIcon;
                }
                if (icon != null) {
                    this.setIcon(icon);
                } else {
                    this.setIcon(AndroidIcons.Android);
                }
            }
        });
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                ActivitySelector.this.mySelectedActivity = null;
                ActivitySelector.this.mySelectedPackage = null;
                for (Object object : ActivitySelector.this.myTree.getSelectionPath().getPath()) {
                    if (object instanceof DeviceInfo.Package) {
                        DeviceInfo.Package pkg = (DeviceInfo.Package)object;
                        ActivitySelector.this.mySelectedActivity = pkg.launchActivity();
                        ActivitySelector.this.mySelectedPackage = pkg;
                    }
                    if (!(object instanceof DeviceInfo.Activity)) continue;
                    ActivitySelector.this.mySelectedActivity = (DeviceInfo.Activity)object;
                }
                if (ActivitySelector.this.mySelectedPackage != null && !ActivitySelector.this.myUserHasChangedTraceName) {
                    ActivitySelector.this.myTraceName.setText(ActivitySelector.this.mySelectedPackage.getDisplayName(), false);
                }
                ActivitySelector.this.buttonOK.setEnabled(ActivitySelector.this.mySelectedPackage != null && ActivitySelector.this.mySelectedActivity != null);
            }
        });
        this.pack();
    }

    public void setListener(@Nullable Listener listener) {
        this.myListener = listener != null ? listener : NULL_LISTENER;
    }

    private void createUIComponents() {
        this.mySearchBox = new RegexFilterComponent(ActivitySelector.class.getName(), 10);
    }

    private ListenableFuture<DeviceInfo> getDeviceInfo(DeviceInfo.Provider dip) {
        ListenableFuture<DeviceInfo> future = dip.getDeviceInfo(18, 18);
        return Futures.transform(future, (Function)new Function<DeviceInfo, DeviceInfo>(){

            public DeviceInfo apply(DeviceInfo deviceInfo) {
                return deviceInfo.transform(new DeviceInfo.Transform<DeviceInfo.Package>(){

                    @Override
                    public DeviceInfo.Package transform(DeviceInfo.Package obj) {
                        if (obj.myActivities.length == 0) {
                            return null;
                        }
                        return obj;
                    }
                });
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextField textField;
        JBLabel jBLabel;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        this.createUIComponents();
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel.setPreferredSize(new Dimension(450, 300));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonOK = jButton2 = new JButton();
        jButton2.setText("Trace...");
        jPanel3.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton = new JButton();
        jButton.setText("Cancel");
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myStatus = jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(0);
        jBLabel.setHorizontalTextPosition(0);
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setVisible(true);
        jPanel4.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Tree tree = new Tree();
        this.myTree = tree;
        tree.setVisible(true);
        tree.setRootVisible(false);
        tree.setHorizontalAutoScrollingEnabled(false);
        tree.setEnabled(true);
        jBScrollPane.setViewportView((Component)tree);
        RegexFilterComponent regexFilterComponent = this.mySearchBox;
        jPanel.add((Component)((Object)regexFilterComponent), new GridConstraints(0, 0, 1, 1, 8, 3, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(450, -1), null));
        this.myTraceName = textField = new TextField();
        jPanel5.add((Component)((Object)textField), new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Trace file name:");
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private static class DeviceTreeModel
    implements TreeModel {
        private final RegexFilterComponent myFilter;
        private final DeviceInfo myDevice;
        private DeviceInfo myFilteredDevice;
        private final List<TreeModelListener> listeners = Lists.newArrayList();

        public DeviceTreeModel(RegexFilterComponent filter, DeviceInfo device) {
            this.myFilter = filter;
            this.myDevice = device;
            this.filter();
            filter.addRegexListener(new RegexFilterComponent.Listener(){

                @Override
                public void filterChanged(RegexFilterComponent filter) {
                    this.filter();
                    this.fireTreeChanged();
                }
            });
        }

        @Override
        public Object getRoot() {
            return this.myDevice;
        }

        @Override
        public Object getChild(Object o, int i) {
            if (o == this.myDevice) {
                return this.myFilteredDevice.myPackages[i];
            }
            return ((DeviceInfo.Package)o).myActivities[i];
        }

        @Override
        public int getChildCount(Object o) {
            if (o == this.myDevice) {
                return this.myFilteredDevice.myPackages.length;
            }
            return ((DeviceInfo.Package)o).myActivities.length;
        }

        @Override
        public boolean isLeaf(Object o) {
            return o instanceof DeviceInfo.Activity;
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object o) {
        }

        @Override
        public int getIndexOfChild(Object o, Object o1) {
            if (o == this.myDevice) {
                for (int i = 0; i < this.myFilteredDevice.myPackages.length; ++i) {
                    if (!this.myFilteredDevice.myPackages[i].equals(o1)) continue;
                    return i;
                }
                return this.myFilteredDevice.myPackages.length;
            }
            DeviceInfo.Package pkg = (DeviceInfo.Package)o;
            for (int i = 0; i < pkg.myActivities.length; ++i) {
                if (!pkg.myActivities[i].equals(o1)) continue;
                return i;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
            List<TreeModelListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(treeModelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            List<TreeModelListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(treeModelListener);
            }
        }

        private void filter() {
            final Pattern pattern = this.myFilter.getPattern();
            if (pattern == null) {
                this.myFilteredDevice = this.myDevice;
                return;
            }
            this.myFilteredDevice = this.myDevice.transform(new DeviceInfo.Transform<DeviceInfo.Package>(){

                @Override
                public DeviceInfo.Package transform(DeviceInfo.Package obj) {
                    if (pattern.matcher(obj.myName).find()) {
                        return obj;
                    }
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireTreeChanged() {
            ArrayList ls;
            List<TreeModelListener> list = this.listeners;
            synchronized (list) {
                ls = Lists.newArrayList(this.listeners);
            }
            for (TreeModelListener l : ls) {
                l.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.myDevice}));
            }
        }
    }

    public static interface Listener {
        public void OnLaunch(DeviceInfo.Package var1, DeviceInfo.Activity var2, String var3);

        public void OnCancel();
    }
}

