/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.viewer.camera;

import com.android.tools.idea.editors.gfxtrace.viewer.CameraModel;
import com.android.tools.idea.editors.gfxtrace.viewer.vec.MatD;

public class CylindricalCameraModel
implements CameraModel {
    private MatD myViewTransform;
    private MatD myProjection;
    private double myDistance = 4.5;
    private double myAngleX;
    private double myAngleY;
    private double myWidth = 36.0;
    private double myHeight = 24.0;
    private double myFocallength = 55.0;

    public CylindricalCameraModel() {
        this.updateModelView();
        this.updateProjection();
    }

    @Override
    public void updateViewport(double screenWidth, double screenHeight) {
        if (screenWidth * 36.0 > screenHeight * 24.0) {
            this.myHeight = 24.0;
            this.myWidth = screenWidth * 24.0 / screenHeight;
        } else {
            this.myHeight = screenHeight * 36.0 / screenWidth;
            this.myWidth = 36.0;
        }
        this.updateProjection();
    }

    @Override
    public void onDrag(double dx, double dy) {
        this.myAngleX += dy / 3.0;
        this.myAngleY += dx / 3.0;
        this.myAngleX = Math.min(Math.max(this.myAngleX, -90.0), 90.0);
        this.updateModelView();
    }

    @Override
    public void onZoom(double dz) {
        this.myDistance = Math.max(3.0, Math.min(4.5, this.myDistance + dz));
        double scale = (this.myDistance - 3.0) / 1.5;
        this.myFocallength = 105.0 - scale * 50.0;
        this.updateModelView();
        this.updateProjection();
    }

    private void updateModelView() {
        this.myViewTransform = MatD.makeTranslationRotXY(0.0, 0.0, -this.myDistance, this.myAngleX, this.myAngleY);
    }

    private void updateProjection() {
        this.myProjection = MatD.projection(this.myWidth, this.myHeight, this.myFocallength, 0.1);
    }

    @Override
    public MatD getProjection() {
        return this.myProjection;
    }

    @Override
    public MatD getViewTransform() {
        return this.myViewTransform;
    }

    @Override
    public double getZoom() {
        return 1.0 - (this.myDistance - 3.0) / 1.5;
    }
}

