/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.actions.SyncProjectAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class RefreshLinkedCppProjectsAction
extends SyncProjectAction {
    public static final Key<Boolean> REFRESH_EXTERNAL_NATIVE_MODELS_KEY = Key.create((String)"refresh.external.native.models");

    public RefreshLinkedCppProjectsAction() {
        super("Refresh Linked C++ Projects");
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/RefreshLinkedCppProjectsAction", "doPerform"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/RefreshLinkedCppProjectsAction", "doPerform"));
        }
        project.putUserData(REFRESH_EXTERNAL_NATIVE_MODELS_KEY, (Object)true);
        super.doPerform(e, project);
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/RefreshLinkedCppProjectsAction", "doUpdate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/RefreshLinkedCppProjectsAction", "doUpdate"));
        }
        if (!RefreshLinkedCppProjectsAction.containsExternalCppProjects(project)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        super.doUpdate(e, project);
    }

    private static boolean containsExternalCppProjects(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/RefreshLinkedCppProjectsAction", "containsExternalCppProjects"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            NativeAndroidGradleModel nativeAndroidModel = NativeAndroidGradleModel.get(module);
            if (nativeAndroidModel == null) continue;
            return true;
        }
        return false;
    }
}

