/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleModel;
import com.android.tools.idea.gradle.ImportedModule;
import com.android.tools.idea.gradle.JavaProject;
import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.actions.RefreshLinkedCppProjectsAction;
import com.android.tools.idea.gradle.project.GradleModelVersionCheck;
import com.android.tools.idea.gradle.project.ProjectImportErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.SyncProjectWithExtraCommandLineOptionsHyperlink;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class AndroidGradleProjectResolver
extends AbstractProjectResolverExtension {
    private static final String DEFAULT_TEST_ARTIFACT = "_android_test_";
    private static final Key<Boolean> IS_ANDROID_PROJECT_KEY = Key.create((String)"IS_ANDROID_PROJECT_KEY");
    @NotNull
    private final ProjectImportErrorHandler myErrorHandler;

    public AndroidGradleProjectResolver() {
        this(new ProjectImportErrorHandler());
    }

    @VisibleForTesting
    AndroidGradleProjectResolver(@NotNull ProjectImportErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "<init>"));
        }
        this.myErrorHandler = errorHandler;
    }

    @NotNull
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "createModule"));
        }
        if (projectDataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDataNode", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "createModule"));
        }
        AndroidProject androidProject = (AndroidProject)this.resolverCtx.getExtraProject(gradleModule, AndroidProject.class);
        if (androidProject != null && !GradleModelVersionCheck.isSupportedVersion(androidProject)) {
            ProjectImportErrorHandler.trackSyncError("syncFailedUnsupportedAndroidModelVersion", androidProject.getModelVersion());
            String msg = AndroidGradleProjectResolver.getUnsupportedModelVersionErrorMsg(GradleModelVersionCheck.getModelVersion(androidProject));
            throw new IllegalStateException(msg);
        }
        if (this.isAndroidGradleProject()) {
            DataNode<ModuleData> dataNode = this.doCreateModule(gradleModule, projectDataNode);
            if (dataNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "createModule"));
            }
            return dataNode;
        }
        DataNode dataNode = this.nextResolver.createModule(gradleModule, projectDataNode);
        if (dataNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "createModule"));
        }
        return dataNode;
    }

    @NotNull
    private DataNode<ModuleData> doCreateModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "doCreateModule"));
        }
        if (projectDataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDataNode", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "doCreateModule"));
        }
        String moduleName = gradleModule.getName();
        if (moduleName == null) {
            throw new IllegalStateException("Module with undefined name detected: " + gradleModule);
        }
        String projectPath = ((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath();
        String moduleConfigPath = GradleProjectResolverUtil.getModuleConfigPath((ProjectResolverContext)this.resolverCtx, (IdeaModule)gradleModule, (String)projectPath);
        String gradlePath = gradleModule.getGradleProject().getPath();
        String moduleId = StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath) ? moduleName : gradlePath;
        ProjectSystemId owner = GradleConstants.SYSTEM_ID;
        String typeId = StdModuleTypes.JAVA.getId();
        ModuleData moduleData = new ModuleData(moduleId, owner, typeId, moduleName, moduleConfigPath, moduleConfigPath);
        ExternalProject externalProject = (ExternalProject)this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject != null) {
            moduleData.setDescription(externalProject.getDescription());
        }
        DataNode dataNode = projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
        if (dataNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "doCreateModule"));
        }
        return dataNode;
    }

    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        File gradleSettingsFile;
        NativeAndroidProject nativeAndroidProject;
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleContentRoots"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleContentRoots"));
        }
        ImportedModule importedModule = new ImportedModule(gradleModule);
        ideModule.createChild(AndroidProjectKeys.IMPORTED_MODULE, (Object)importedModule);
        GradleProject gradleProject = gradleModule.getGradleProject();
        GradleScript buildScript = null;
        try {
            buildScript = gradleProject.getBuildScript();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (buildScript == null || !this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleContentRoots(gradleModule, ideModule);
            return;
        }
        File moduleRootDirPath = new File(FileUtil.toSystemDependentName((String)((ModuleData)ideModule.getData()).getLinkedExternalProjectPath()));
        AndroidProject androidProject = (AndroidProject)this.resolverCtx.getExtraProject(gradleModule, AndroidProject.class);
        boolean androidProjectWithoutVariants = false;
        if (androidProject != null) {
            Variant selectedVariant = AndroidGradleProjectResolver.getVariantToSelect(androidProject);
            if (selectedVariant == null) {
                androidProjectWithoutVariants = true;
            } else {
                AndroidGradleModel androidModel = new AndroidGradleModel(GradleUtil.GRADLE_SYSTEM_ID, gradleModule.getName(), moduleRootDirPath, androidProject, selectedVariant.getName(), DEFAULT_TEST_ARTIFACT);
                ideModule.createChild(AndroidProjectKeys.ANDROID_MODEL, (Object)androidModel);
            }
        }
        if ((nativeAndroidProject = (NativeAndroidProject)this.resolverCtx.getExtraProject(gradleModule, NativeAndroidProject.class)) != null) {
            ideModule.createChild(AndroidProjectKeys.NATIVE_ANDROID_MODEL, (Object)new NativeAndroidGradleModel(GradleUtil.GRADLE_SYSTEM_ID, gradleModule.getName(), moduleRootDirPath, nativeAndroidProject));
        }
        if ((gradleSettingsFile = new File(moduleRootDirPath, "settings.gradle")).isFile() && androidProject == null && nativeAndroidProject == null) {
            this.createJavaProject(gradleModule, ideModule, false);
            return;
        }
        BuildScriptClasspathModel buildScriptModel = (BuildScriptClasspathModel)this.resolverCtx.getExtraProject(BuildScriptClasspathModel.class);
        String gradleVersion = buildScriptModel != null ? buildScriptModel.getGradleVersion() : null;
        File buildFilePath = buildScript.getSourceFile();
        GradleModel gradleModel = GradleModel.create(gradleModule.getName(), gradleProject, buildFilePath, gradleVersion);
        ideModule.createChild(AndroidProjectKeys.GRADLE_MODEL, (Object)gradleModel);
        if (nativeAndroidProject == null && (androidProject == null || androidProjectWithoutVariants)) {
            this.createJavaProject(gradleModule, ideModule, androidProjectWithoutVariants);
        }
    }

    private void createJavaProject(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, boolean androidProjectWithoutVariants) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "createJavaProject"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "createJavaProject"));
        }
        ModuleExtendedModel model = (ModuleExtendedModel)this.resolverCtx.getExtraProject(gradleModule, ModuleExtendedModel.class);
        JavaProject javaProject = JavaProject.create(gradleModule, model, androidProjectWithoutVariants);
        ideModule.createChild(AndroidProjectKeys.JAVA_PROJECT, (Object)javaProject);
    }

    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleCompileOutputSettings"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleCompileOutputSettings"));
        }
        if (!this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleCompileOutputSettings(gradleModule, ideModule);
        }
    }

    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleDependencies"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleDependencies"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleDependencies"));
        }
        if (!this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleDependencies(gradleModule, ideModule, ideProject);
        }
    }

    private boolean isAndroidGradleProject() {
        Boolean isAndroidGradleProject = (Boolean)this.resolverCtx.getUserData(IS_ANDROID_PROJECT_KEY);
        if (isAndroidGradleProject != null) {
            return isAndroidGradleProject;
        }
        isAndroidGradleProject = this.resolverCtx.hasModulesWithModel(AndroidProject.class) || this.resolverCtx.hasModulesWithModel(NativeAndroidProject.class);
        return (Boolean)this.resolverCtx.putUserDataIfAbsent(IS_ANDROID_PROJECT_KEY, (Object)isAndroidGradleProject);
    }

    @NotNull
    public Set<Class> getExtraProjectModelClasses() {
        HashSet hashSet = Sets.newHashSet((Object[])new Class[]{AndroidProject.class, NativeAndroidProject.class});
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getExtraProjectModelClasses"));
        }
        return hashSet;
    }

    public void preImportCheck() {
        Application application;
        Runnable task;
        if (AndroidPlugin.isGuiTestingMode() && (task = (Runnable)(application = ApplicationManager.getApplication()).getUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_SYNC_TASK_IN_GUI_TEST_KEY)) != null) {
            application.putUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_SYNC_TASK_IN_GUI_TEST_KEY, null);
            task.run();
        }
    }

    @NotNull
    public List<Pair<String, String>> getExtraJvmArgs() {
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID)) {
            File androidHomePath;
            LocalProperties localProperties;
            ArrayList args = Lists.newArrayList();
            if (!AndroidStudioInitializer.isAndroidStudio() && (localProperties = this.getLocalProperties()).getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getAndroidSdkPath()) != null) {
                args.add(Pair.create((Object)"android.home", (Object)androidHomePath.getPath()));
            }
            ArrayList arrayList = args;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getExtraJvmArgs"));
            }
            return arrayList;
        }
        List<Pair<String, String>> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getExtraJvmArgs"));
        }
        return list;
    }

    @NotNull
    public List<String> getExtraCommandLineArgs() {
        Boolean refreshExternalNativeModels;
        String[] commandLineOptions;
        ArrayList args = Lists.newArrayList();
        Project project = this.findProject();
        if (project != null && (commandLineOptions = (String[])project.getUserData(SyncProjectWithExtraCommandLineOptionsHyperlink.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY)) != null) {
            project.putUserData(SyncProjectWithExtraCommandLineOptionsHyperlink.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY, null);
            Collections.addAll(args, commandLineOptions);
        }
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only.advanced", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
        String ideVersion = ApplicationInfo.getInstance().getStrictVersion();
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.studio.version", (String)ideVersion));
        if (project != null && (refreshExternalNativeModels = (Boolean)project.getUserData(RefreshLinkedCppProjectsAction.REFRESH_EXTERNAL_NATIVE_MODELS_KEY)) != null) {
            project.putUserData(RefreshLinkedCppProjectsAction.REFRESH_EXTERNAL_NATIVE_MODELS_KEY, null);
            args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.refresh.external.native.model", (boolean)refreshExternalNativeModels));
        }
        if (AndroidPlugin.isGuiTestingMode()) {
            ApplicationManager.getApplication().putUserData(AndroidPlugin.GRADLE_SYNC_COMMAND_LINE_OPTIONS_KEY, (Object)ArrayUtil.toStringArray((Collection)args));
        }
        GradleUtil.addLocalMavenRepoInitScriptCommandLineOption(args);
        ArrayList arrayList = args;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getExtraCommandLineArgs"));
        }
        return arrayList;
    }

    @Nullable
    private Project findProject() {
        String projectDir = this.resolverCtx.getProjectPath();
        if (StringUtil.isNotEmpty((String)projectDir)) {
            Project[] projects;
            File projectDirPath = new File(FileUtil.toSystemDependentName((String)projectDir));
            for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                File currentPath;
                String basePath = project.getBasePath();
                if (basePath == null || !FileUtil.filesEqual((File)projectDirPath, (File)(currentPath = new File(basePath)))) continue;
                return project;
            }
        }
        return null;
    }

    @NotNull
    private LocalProperties getLocalProperties() {
        LocalProperties localProperties;
        block2: {
            File projectDir = new File(FileUtil.toSystemDependentName((String)this.resolverCtx.getProjectPath()));
            try {
                localProperties = new LocalProperties(projectDir);
                if (localProperties != null) break block2;
            }
            catch (IOException e) {
                String msg = String.format("Unable to read local.properties file in project '%1$s'", projectDir.getPath());
                throw new ExternalSystemException(msg, (Throwable)e, new String[0]);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getLocalProperties"));
        }
        return localProperties;
    }

    @NotNull
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        Throwable rootCause;
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getUserFriendlyError"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getUserFriendlyError"));
        }
        String msg = error.getMessage();
        if (msg != null && !msg.contains("The project is using an unsupported version of the Android Gradle plug-in") && (rootCause = ExceptionUtil.getRootCause((Throwable)error)) instanceof ClassNotFoundException && ("org.gradle.api.artifacts.result.ResolvedComponentResult".equals(msg = rootCause.getMessage()) || "org.gradle.api.artifacts.result.ResolvedModuleVersionResult".equals(msg))) {
            ProjectImportErrorHandler.trackSyncError("gradleSyncFailure", "syncFailedUnsupportedGradleVersion");
            ExternalSystemException externalSystemException = new ExternalSystemException("The project is using an unsupported version of Gradle.");
            if (externalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getUserFriendlyError"));
            }
            return externalSystemException;
        }
        ExternalSystemException userFriendlyError = this.myErrorHandler.getUserFriendlyError(error, projectPath, buildFilePath);
        if (userFriendlyError == null) {
            ProjectImportErrorHandler.trackSyncError(error);
            ExternalSystemException externalSystemException = this.nextResolver.getUserFriendlyError(error, projectPath, buildFilePath);
            if (externalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getUserFriendlyError"));
            }
            return externalSystemException;
        }
        ExternalSystemException externalSystemException = userFriendlyError;
        if (externalSystemException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getUserFriendlyError"));
        }
        return externalSystemException;
    }

    @NotNull
    private static String getUnsupportedModelVersionErrorMsg(@Nullable GradleVersion modelVersion) {
        StringBuilder builder = new StringBuilder();
        builder.append("The project is using an unsupported version of the Android Gradle plug-in");
        String recommendedVersion = String.format("The recommended version is %1$s.", "2.2.0");
        if (modelVersion != null) {
            builder.append(String.format(" (%1$s).", modelVersion.toString())).append(" ").append(recommendedVersion);
            if (modelVersion.getMajor() == 0 && modelVersion.getMinor() <= 8) {
                builder.append("\n\nStarting with version 0.9.0 incompatible changes were introduced in the build language.\n").append("Please read the migration guide").append(" to learn how to update your project.");
            }
        } else {
            builder.append(". ").append(recommendedVersion);
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getUnsupportedModelVersionErrorMsg"));
        }
        return string;
    }

    @Nullable
    private static Variant getVariantToSelect(@NotNull AndroidProject androidProject) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getVariantToSelect"));
        }
        Collection variants = androidProject.getVariants();
        if (variants.size() == 1) {
            Variant variant = (Variant)ContainerUtil.getFirstItem((Collection)variants);
            assert (variant != null);
            return variant;
        }
        for (Variant variant : variants) {
            if (!"debug".equals(variant.getName())) continue;
            return variant;
        }
        ArrayList sortedVariants = Lists.newArrayList((Iterable)variants);
        Collections.sort(sortedVariants, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        return sortedVariants.isEmpty() ? null : (Variant)sortedVariants.get(0);
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "enhanceRemoteProcessing"));
        }
        ArrayList classPath = Lists.newArrayList();
        ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(((Object)((Object)this)).getClass()), (Collection)classPath);
        ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(Revision.class), (Collection)classPath);
        ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(AndroidGradleSettings.class), (Collection)classPath);
        ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(AndroidProject.class), (Collection)classPath);
        parameters.getClassPath().addAll((List)classPath);
    }
}

