/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.lang.proguard.ProguardFileType;
import com.android.tools.idea.navigator.nodes.AndroidBuildScriptNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import icons.GradleIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidBuildScriptsGroupNode
extends ProjectViewNode<List<PsiDirectory>> {
    public AndroidBuildScriptsGroupNode(@NotNull Project project, @NotNull ViewSettings viewSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "<init>"));
        }
        if (viewSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewSettings", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "<init>"));
        }
        super(project, Collections.emptyList(), viewSettings);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "contains"));
        }
        return this.getBuildScriptsWithQualifiers().containsKey(file);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Map<VirtualFile, String> scripts = this.getBuildScriptsWithQualifiers();
        ArrayList children = Lists.newArrayListWithExpectedSize((int)scripts.size());
        for (Map.Entry<VirtualFile, String> scriptWithQualifier : scripts.entrySet()) {
            this.addPsiFile(children, scriptWithQualifier.getKey(), scriptWithQualifier.getValue());
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "getChildren"));
        }
        return arrayList;
    }

    @NotNull
    private Map<VirtualFile, String> getBuildScriptsWithQualifiers() {
        VirtualFile file;
        File userSettingsFile;
        HashMap buildScripts = Maps.newHashMap();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String moduleName = AndroidBuildScriptsGroupNode.getPrefixForModule(module) + module.getName();
            VirtualFile gradleBuildFile = GradleUtil.getGradleBuildFile(module);
            if (gradleBuildFile != null) {
                buildScripts.put(gradleBuildFile, moduleName);
            }
            for (VirtualFile file2 : AndroidBuildScriptsGroupNode.findAllGradleScriptsInModule(module)) {
                if (file2.getFileType() == ProguardFileType.INSTANCE) {
                    buildScripts.put(file2, String.format("ProGuard Rules for %1$s", module.getName()));
                    continue;
                }
                buildScripts.put(file2, moduleName);
            }
        }
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null) {
            AndroidBuildScriptsGroupNode.findChildAndAddToMapIfFound("settings.gradle", baseDir, "Project Settings", buildScripts);
            AndroidBuildScriptsGroupNode.findChildAndAddToMapIfFound("gradle.properties", baseDir, "Project Properties", buildScripts);
            VirtualFile child = baseDir.findFileByRelativePath(FileUtilRt.toSystemIndependentName((String)GradleUtil.GRADLEW_PROPERTIES_PATH));
            if (child != null) {
                buildScripts.put(child, "Gradle Version");
            }
            AndroidBuildScriptsGroupNode.findChildAndAddToMapIfFound("local.properties", baseDir, "SDK Location", buildScripts);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && (userSettingsFile = GradleUtil.getGradleUserSettingsFile()) != null && (file = VfsUtil.findFileByIoFile((File)userSettingsFile, (boolean)false)) != null) {
            buildScripts.put(file, "Global Properties");
        }
        buildScripts.remove(null);
        HashMap hashMap = buildScripts;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "getBuildScriptsWithQualifiers"));
        }
        return hashMap;
    }

    private static void findChildAndAddToMapIfFound(@NotNull String childName, @NotNull VirtualFile parent, @NotNull String value, @NotNull Map<VirtualFile, String> map) {
        if (childName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childName", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "findChildAndAddToMapIfFound"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "findChildAndAddToMapIfFound"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "findChildAndAddToMapIfFound"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "findChildAndAddToMapIfFound"));
        }
        VirtualFile child = parent.findChild(childName);
        if (child != null) {
            map.put(child, value);
        }
    }

    private static String getPrefixForModule(@NotNull Module m) {
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "getPrefixForModule"));
        }
        return GradleUtil.isRootModuleWithNoSources(m) ? "Project: " : "Module: ";
    }

    @NotNull
    private static List<VirtualFile> findAllGradleScriptsInModule(@NotNull Module m) {
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "findAllGradleScriptsInModule"));
        }
        File moduleDir = new File(m.getModuleFilePath()).getParentFile();
        VirtualFile dir = VfsUtil.findFileByIoFile((File)moduleDir, (boolean)false);
        if (dir == null || dir.getChildren() == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "findAllGradleScriptsInModule"));
            }
            return list;
        }
        ArrayList files = Lists.newArrayList();
        for (VirtualFile child : dir.getChildren()) {
            if (!child.isValid() || child.isDirectory() || !child.getName().endsWith("gradle") && child.getFileType() != ProguardFileType.INSTANCE || ApplicationManager.getApplication().isUnitTestMode() && (child.getName().startsWith("ijinit") || child.getName().startsWith("asLocalRepo"))) continue;
            files.add(child);
        }
        ArrayList arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "findAllGradleScriptsInModule"));
        }
        return arrayList;
    }

    private void addPsiFile(@NotNull List<PsiFileNode> psiFileNodes, @Nullable VirtualFile file, @Nullable String qualifier) {
        if (psiFileNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFileNodes", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "addPsiFile"));
        }
        if (file == null) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile != null) {
            psiFileNodes.add(new AndroidBuildScriptNode(this.myProject, psiFile, this.getSettings(), qualifier));
        }
    }

    public int getWeight() {
        return 100;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "update"));
        }
        presentation.setPresentableText("Gradle Scripts");
        presentation.setIcon(GradleIcons.Gradle);
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return "Gradle Scripts";
    }
}

