/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiResourceRepository
extends LocalResourceRepository {
    protected List<? extends LocalResourceRepository> myChildren;
    private long[] myModificationCounts;
    private Map<ResourceType, ListMultimap<String, ResourceItem>> myItems;
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> myCachedTypeMaps;
    private final Map<ResourceType, Boolean> myCachedHasResourcesOfType;
    private Map<String, DataBindingInfo> myDataBindingResourceFiles;
    private long myDataBindingResourceFilesModificationCount;

    MultiResourceRepository(@NotNull String displayName, @NotNull List<? extends LocalResourceRepository> children) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/android/tools/idea/res/MultiResourceRepository", "<init>"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/android/tools/idea/res/MultiResourceRepository", "<init>"));
        }
        super(displayName);
        this.myItems = Maps.newEnumMap(ResourceType.class);
        this.myCachedTypeMaps = Maps.newEnumMap(ResourceType.class);
        this.myCachedHasResourcesOfType = Maps.newEnumMap(ResourceType.class);
        this.myDataBindingResourceFiles = Maps.newHashMap();
        this.myDataBindingResourceFilesModificationCount = Long.MIN_VALUE;
        this.setChildren(children);
    }

    protected void setChildren(@NotNull List<? extends LocalResourceRepository> children) {
        LocalResourceRepository resources;
        int i;
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/android/tools/idea/res/MultiResourceRepository", "setChildren"));
        }
        if (this.myChildren != null) {
            for (i = this.myChildren.size() - 1; i >= 0; --i) {
                resources = this.myChildren.get(i);
                resources.removeParent(this);
            }
        }
        this.myGeneration = ourModificationCounter.incrementAndGet();
        this.myChildren = children;
        this.myModificationCounts = new long[children.size()];
        if (children.size() == 1) {
            LocalResourceRepository child = children.get(0);
            child.myGeneration = this.myGeneration;
        }
        for (i = this.myChildren.size() - 1; i >= 0; --i) {
            resources = this.myChildren.get(i);
            resources.addParent(this);
            this.myModificationCounts[i] = resources.getModificationCount();
        }
        this.clearCache();
        this.invalidateItemCaches(new ResourceType[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        this.myItems = null;
        MultiResourceRepository multiResourceRepository = this;
        synchronized (multiResourceRepository) {
            this.myCachedTypeMaps.clear();
            this.myCachedHasResourcesOfType.clear();
        }
    }

    public List<? extends LocalResourceRepository> getChildren() {
        return this.myChildren;
    }

    @Override
    public long getModificationCount() {
        if (this.myChildren.size() == 1) {
            return this.myChildren.get(0).getModificationCount();
        }
        boolean changed = false;
        for (int i = this.myChildren.size() - 1; i >= 0; --i) {
            LocalResourceRepository resources = this.myChildren.get(i);
            long rev = resources.getModificationCount();
            if (rev == this.myModificationCounts[i]) continue;
            this.myModificationCounts[i] = rev;
            changed = true;
        }
        if (changed) {
            this.myGeneration = ourModificationCounter.incrementAndGet();
        }
        return this.myGeneration;
    }

    @Override
    @Nullable
    public DataBindingInfo getDataBindingInfoForLayout(String layoutName) {
        for (LocalResourceRepository localResourceRepository : this.myChildren) {
            DataBindingInfo info = localResourceRepository.getDataBindingInfoForLayout(layoutName);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, DataBindingInfo> getDataBindingResourceFiles() {
        long modificationCount = this.getModificationCount();
        if (this.myDataBindingResourceFilesModificationCount == modificationCount) {
            Map<String, DataBindingInfo> map = this.myDataBindingResourceFiles;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/MultiResourceRepository", "getDataBindingResourceFiles"));
            }
            return map;
        }
        HashMap selected = Maps.newHashMap();
        for (LocalResourceRepository localResourceRepository : this.myChildren) {
            Map<String, DataBindingInfo> childFiles = localResourceRepository.getDataBindingResourceFiles();
            if (childFiles == null) continue;
            selected.putAll(childFiles);
        }
        this.myDataBindingResourceFiles = Collections.unmodifiableMap(selected);
        this.myDataBindingResourceFilesModificationCount = modificationCount;
        Map<String, DataBindingInfo> map = this.myDataBindingResourceFiles;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/MultiResourceRepository", "getDataBindingResourceFiles"));
        }
        return map;
    }

    protected Map<ResourceType, ListMultimap<String, ResourceItem>> getMap() {
        if (this.myItems == null) {
            if (this.myChildren.size() == 1) {
                this.myItems = this.myChildren.get(0).getItems();
            } else {
                EnumMap map = Maps.newEnumMap(ResourceType.class);
                for (ResourceType type : ResourceType.values()) {
                    map.put(type, this.getMap(type, false));
                }
                this.myItems = map;
            }
        }
        return this.myItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(ResourceType type, boolean create) {
        MultiResourceRepository multiResourceRepository = this;
        synchronized (multiResourceRepository) {
            ListMultimap<String, ResourceItem> map = this.myCachedTypeMaps.get(type);
            if (map != null) {
                return map;
            }
        }
        if (this.myChildren.size() == 1) {
            LocalResourceRepository child = this.myChildren.get(0);
            if (child instanceof MultiResourceRepository) {
                return ((MultiResourceRepository)child).getMap(type);
            }
            return (ListMultimap)child.getItems().get(type);
        }
        ArrayListMultimap map = ArrayListMultimap.create();
        HashSet visited = Sets.newHashSet();
        HashMultimap seenQualifiers = HashMultimap.create();
        this.merge(visited, type, (SetMultimap<String, String>)seenQualifiers, (ListMultimap<String, ResourceItem>)map);
        MultiResourceRepository multiResourceRepository2 = this;
        synchronized (multiResourceRepository2) {
            this.myCachedTypeMaps.put(type, (ListMultimap<String, ResourceItem>)map);
        }
        return map;
    }

    protected ListMultimap<String, ResourceItem> getMap(ResourceType type) {
        return super.getMap(type);
    }

    public Map<ResourceType, ListMultimap<String, ResourceItem>> getItems() {
        return this.getMap();
    }

    @Override
    protected void doMerge(@NotNull Set<LocalResourceRepository> visited, @NotNull ResourceType type, @NotNull SetMultimap<String, String> seenQualifiers, @NotNull ListMultimap<String, ResourceItem> result) {
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/android/tools/idea/res/MultiResourceRepository", "doMerge"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/res/MultiResourceRepository", "doMerge"));
        }
        if (seenQualifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seenQualifiers", "com/android/tools/idea/res/MultiResourceRepository", "doMerge"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/res/MultiResourceRepository", "doMerge"));
        }
        for (int i = this.myChildren.size() - 1; i >= 0; --i) {
            this.myChildren.get(i).merge(visited, type, seenQualifiers, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResourcesOfType(@NotNull ResourceType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/res/MultiResourceRepository", "hasResourcesOfType"));
        }
        if (this.myChildren.size() == 1) {
            return this.myChildren.get(0).hasResourcesOfType(type);
        }
        MultiResourceRepository multiResourceRepository = this;
        synchronized (multiResourceRepository) {
            Boolean result = this.myCachedHasResourcesOfType.get(type);
            if (result != null) {
                return result;
            }
        }
        HashSet visited = Sets.newHashSet();
        boolean result = this.computeHasResourcesOfType(type, visited);
        MultiResourceRepository multiResourceRepository2 = this;
        synchronized (multiResourceRepository2) {
            this.myCachedHasResourcesOfType.put(type, result);
        }
        return result;
    }

    @Override
    protected boolean computeHasResourcesOfType(@NotNull ResourceType type, @NotNull Set<LocalResourceRepository> visited) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/res/MultiResourceRepository", "computeHasResourcesOfType"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/android/tools/idea/res/MultiResourceRepository", "computeHasResourcesOfType"));
        }
        if (!visited.add(this)) {
            return false;
        }
        for (LocalResourceRepository localResourceRepository : this.myChildren) {
            if (!localResourceRepository.computeHasResourcesOfType(type, visited)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        for (int i = this.myChildren.size() - 1; i >= 0; --i) {
            LocalResourceRepository resources = this.myChildren.get(i);
            resources.removeParent(this);
            Disposer.dispose((Disposable)resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(@NotNull LocalResourceRepository repository, ResourceType ... types) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/android/tools/idea/res/MultiResourceRepository", "invalidateCache"));
        }
        assert (this.myChildren.contains((Object)repository)) : repository;
        MultiResourceRepository multiResourceRepository = this;
        synchronized (multiResourceRepository) {
            if (types == null || types.length == 0) {
                this.myCachedTypeMaps.clear();
                this.myCachedHasResourcesOfType.clear();
            } else {
                for (ResourceType type : types) {
                    this.myCachedTypeMaps.remove(type);
                    this.myCachedHasResourcesOfType.remove(type);
                }
            }
        }
        this.myItems = null;
        this.myGeneration = ourModificationCounter.incrementAndGet();
        this.invalidateItemCaches(types);
    }

    @Override
    public boolean isScanPending(PsiFile psiFile) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        for (int i = this.myChildren.size() - 1; i >= 0; --i) {
            LocalResourceRepository resources = this.myChildren.get(i);
            if (!resources.isScanPending(psiFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void sync() {
        super.sync();
        for (int i = this.myChildren.size() - 1; i >= 0; --i) {
            LocalResourceRepository resources = this.myChildren.get(i);
            resources.sync();
        }
    }

    int getChildCount() {
        return this.myChildren.size();
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        HashSet result = Sets.newHashSet();
        for (LocalResourceRepository localResourceRepository : this.myChildren) {
            result.addAll(localResourceRepository.computeResourceDirs());
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/MultiResourceRepository", "computeResourceDirs"));
        }
        return hashSet;
    }
}

