/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.graphics;

import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.jetbrains.annotations.NotNull;

public class NlGraphics {
    private final ScreenView myScreenView;
    private final Graphics2D myGraphics;
    @NotNull
    private NlDrawingStyle myStyle;
    private static final int MIN_LENGTH = 10;
    private static final int ARROW_SIZE = 5;

    public NlGraphics(@NotNull Graphics2D graphics, @NotNull ScreenView screenView) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "<init>"));
        }
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "<init>"));
        }
        this.myStyle = NlDrawingStyle.INVALID;
        this.myGraphics = graphics;
        this.myScreenView = screenView;
    }

    public void useStyle(@NotNull NlDrawingStyle style) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "useStyle"));
        }
        this.myStyle = style;
    }

    public void fillRect(int x, int y, int width, int height) {
        Color fillColor = this.myStyle.getFillColor();
        if (fillColor != null) {
            NlGraphics.useFill(this.myStyle, this.myGraphics);
            x = Coordinates.getSwingX(this.myScreenView, x);
            y = Coordinates.getSwingY(this.myScreenView, y);
            width = Coordinates.getSwingDimension(this.myScreenView, width);
            height = Coordinates.getSwingDimension(this.myScreenView, height);
            NlGraphics.fillRect(this.myStyle, this.myGraphics, x, y, width, height);
        }
    }

    public void drawTop(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawTop"));
        }
        this.drawLine(component.x, component.y, component.x + component.w, component.y);
    }

    public void drawTop(@NotNull Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rectangle", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawTop"));
        }
        this.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
    }

    public void drawLeft(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawLeft"));
        }
        this.drawLine(component.x, component.y, component.x, component.y + component.h);
    }

    public void drawLeft(@NotNull Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rectangle", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawLeft"));
        }
        this.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
    }

    public void drawRight(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawRight"));
        }
        this.drawLine(component.x + component.w, component.y, component.x + component.w, component.y + component.h);
    }

    public void drawRight(@NotNull Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rectangle", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawRight"));
        }
        this.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public void drawBottom(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawBottom"));
        }
        this.drawLine(component.x, component.y + component.h, component.x + component.w, component.y + component.h);
    }

    public void drawBottom(@NotNull Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rectangle", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawBottom"));
        }
        this.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        x1 = Coordinates.getSwingX(this.myScreenView, x1);
        x2 = Coordinates.getSwingX(this.myScreenView, x2);
        y1 = Coordinates.getSwingY(this.myScreenView, y1);
        y2 = Coordinates.getSwingY(this.myScreenView, y2);
        NlGraphics.drawLine(this.myStyle, this.myGraphics, x1, y1, x2, y2);
    }

    public void drawRect(int x, int y, int width, int height) {
        x = Coordinates.getSwingX(this.myScreenView, x);
        y = Coordinates.getSwingY(this.myScreenView, y);
        width = Coordinates.getSwingDimension(this.myScreenView, width);
        height = Coordinates.getSwingDimension(this.myScreenView, height);
        NlGraphics.drawRect(this.myStyle, this.myGraphics, x, y, width, height);
    }

    public void drawArrow(int x1, int y1, int x2, int y2) {
        x1 = Coordinates.getSwingX(this.myScreenView, x1);
        x2 = Coordinates.getSwingX(this.myScreenView, x2);
        y1 = Coordinates.getSwingY(this.myScreenView, y1);
        y2 = Coordinates.getSwingY(this.myScreenView, y2);
        NlGraphics.drawArrow(this.myStyle, this.myGraphics, x1, y1, x2, y2);
    }

    public void drawCross(int radius) {
        radius = Coordinates.getSwingDimension(this.myScreenView, radius);
        NlGraphics.drawCross(this.myStyle, this.myGraphics, radius);
    }

    public static void fillRect(@NotNull NlDrawingStyle style, @NotNull Graphics gc, int x, int y, int width, int height) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "fillRect"));
        }
        if (gc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "fillRect"));
        }
        Color fillColor = style.getFillColor();
        if (fillColor != null) {
            NlGraphics.useFill(style, gc);
            gc.fillRect(x + 1, y + 1, width - 1, height - 1);
        }
    }

    public static void drawFilledRect(@NotNull NlDrawingStyle style, @NotNull Graphics gc, int x, int y, int width, int height) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawFilledRect"));
        }
        if (gc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawFilledRect"));
        }
        Color fillColor = style.getFillColor();
        if (fillColor != null) {
            NlGraphics.useFill(style, gc);
            gc.setColor(fillColor);
            gc.fillRect(x + 1, y + 1, width - 2, height - 2);
        }
        NlGraphics.useStroke(style, gc);
        if (style.getStrokeColor() != null) {
            gc.drawRect(x, y, width - 1, height - 1);
        }
    }

    public static void drawStrokeFilledRect(@NotNull NlDrawingStyle style, @NotNull Graphics gc, int x, int y, int width, int height) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawStrokeFilledRect"));
        }
        if (gc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawStrokeFilledRect"));
        }
        NlGraphics.useStroke(style, gc);
        if (style.getStrokeColor() != null) {
            gc.fillRect(x, y, width, height);
        }
    }

    public static void drawRect(@NotNull NlDrawingStyle style, @NotNull Graphics gc, int x, int y, int width, int height) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawRect"));
        }
        if (gc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawRect"));
        }
        NlGraphics.useStroke(style, gc);
        gc.drawRect(x, y, width - 1, height - 1);
    }

    public static void drawLine(@NotNull NlDrawingStyle style, @NotNull Graphics gc, int x1, int y1, int x2, int y2) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawLine"));
        }
        if (gc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawLine"));
        }
        NlGraphics.useStroke(style, gc);
        gc.drawLine(x1, y1, x2, y2);
    }

    public static void drawArrow(@NotNull NlDrawingStyle style, @NotNull Graphics graphics, int x1, int y1, int x2, int y2) {
        int delta;
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawArrow"));
        }
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawArrow"));
        }
        Color strokeColor = style.getStrokeColor();
        if (strokeColor != graphics.getColor()) {
            graphics.setColor(strokeColor);
        }
        if (graphics instanceof Graphics2D) {
            Graphics2D gc2 = (Graphics2D)graphics;
            Stroke stroke = style.getStroke();
            if (gc2.getStroke() != stroke) {
                gc2.setStroke(stroke);
            }
        }
        int arrowWidth = 5;
        int arrowHeight = 5;
        if (x1 == x2 && Math.abs(y1 - y2) < 10) {
            delta = (10 - Math.abs(y1 - y2)) / 2;
            if (y1 < y2) {
                y1 -= delta;
                y2 += delta;
            } else {
                y1 += delta;
                y2 -= delta;
            }
        } else if (y1 == y2 && Math.abs(x1 - x2) < 10) {
            delta = (10 - Math.abs(x1 - x2)) / 2;
            if (x1 < x2) {
                x1 -= delta;
                x2 += delta;
            } else {
                x1 += delta;
                x2 -= delta;
            }
        }
        graphics.drawLine(x1, y1, x2, y2);
        if (x1 == x2) {
            if (y2 > y1) {
                graphics.drawLine(x2 - arrowWidth, y2 - arrowHeight, x2, y2);
                graphics.drawLine(x2 + arrowWidth, y2 - arrowHeight, x2, y2);
            } else {
                graphics.drawLine(x2 - arrowWidth, y2 + arrowHeight, x2, y2);
                graphics.drawLine(x2 + arrowWidth, y2 + arrowHeight, x2, y2);
            }
        } else if (y1 == y2) {
            if (x2 > x1) {
                graphics.drawLine(x2 - arrowHeight, y2 - arrowWidth, x2, y2);
                graphics.drawLine(x2 - arrowHeight, y2 + arrowWidth, x2, y2);
            } else {
                graphics.drawLine(x2 + arrowHeight, y2 - arrowWidth, x2, y2);
                graphics.drawLine(x2 + arrowHeight, y2 + arrowWidth, x2, y2);
            }
        } else {
            int dy = y2 - y1;
            int dx = x2 - x1;
            double angle = Math.atan2(dy, dx);
            double lineLength = Math.sqrt(dy * dy + dx * dx);
            double ax = (double)x1 + lineLength - (double)arrowHeight;
            double ay = y1 - arrowWidth;
            int rx = (int)(Math.cos(angle) * (ax - (double)x1) - Math.sin(angle) * (ay - (double)y1) + (double)x1);
            int ry = (int)(Math.sin(angle) * (ax - (double)x1) + Math.cos(angle) * (ay - (double)y1) + (double)y1);
            graphics.drawLine(x2, y2, rx, ry);
            ay = y1 + arrowWidth;
            rx = (int)(Math.cos(angle) * (ax - (double)x1) - Math.sin(angle) * (ay - (double)y1) + (double)x1);
            ry = (int)(Math.sin(angle) * (ax - (double)x1) + Math.cos(angle) * (ay - (double)y1) + (double)y1);
            graphics.drawLine(x2, y2, rx, ry);
        }
    }

    public static void drawCross(@NotNull NlDrawingStyle style, @NotNull Graphics g, int radius) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawCross"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "drawCross"));
        }
        int size2 = (radius - 3) / 2;
        Color fillColor = style.getFillColor();
        if (fillColor != null) {
            NlGraphics.fillRect(style, g, 0, size2, radius, 3);
            NlGraphics.fillRect(style, g, size2, 0, 3, radius);
        } else {
            NlGraphics.drawLine(style, g, 0, size2 + 1, radius, size2 + 1);
            NlGraphics.drawLine(style, g, size2 + 1, 0, size2 + 1, radius);
        }
    }

    public static void useStroke(@NotNull NlDrawingStyle style, @NotNull Graphics gc) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "useStroke"));
        }
        if (gc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "useStroke"));
        }
        Color strokeColor = style.getStrokeColor();
        if (strokeColor != gc.getColor()) {
            gc.setColor(strokeColor);
        }
        if (gc instanceof Graphics2D) {
            Graphics2D gc2 = (Graphics2D)gc;
            Stroke stroke = style.getStroke();
            if (gc2.getStroke() != stroke) {
                gc2.setStroke(stroke);
            }
        }
    }

    public static void useFill(@NotNull NlDrawingStyle style, @NotNull Graphics gc) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "useFill"));
        }
        if (gc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/graphics/NlGraphics", "useFill"));
        }
        Color fillColor = style.getFillColor();
        if (fillColor != null && fillColor != gc.getColor()) {
            gc.setColor(fillColor);
        }
    }
}

