/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionListener;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.structure.NlComponentTreeModel;
import com.android.tools.idea.uibuilder.structure.NlDropListener;
import com.android.tools.idea.uibuilder.structure.StructureTreeDecorator;
import com.android.tools.idea.uibuilder.structure.TreeTransferHandler;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Sets;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlComponentTree
extends Tree
implements DesignSurfaceListener,
ModelListener,
SelectionListener,
DataProvider,
DeleteProvider {
    private static final Insets INSETS = new Insets(0, 6, 0, 6);
    private final AtomicBoolean mySelectionIsUpdating = new AtomicBoolean(false);
    private final MergingUpdateQueue myUpdateQueue = new MergingUpdateQueue("android.layout.structure-pane", 250, true, null, null, null, Alarm.ThreadToUse.SWING_THREAD);
    private ScreenView myScreenView;
    private NlModel myModel;
    private TreePath myInsertionPath;
    private InsertionPoint myInsertionPoint;
    private boolean mySkipWait;

    public NlComponentTree(@Nullable DesignSurface designSurface) {
        this.setModel(new NlComponentTreeModel());
        this.getSelectionModel().setSelectionMode(4);
        this.setBorder(new EmptyBorder(INSETS));
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.setToggleClickCount(2);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        TreeUtil.installActions((JTree)((Object)this));
        this.createCellRenderer();
        this.addTreeSelectionListener(new StructurePaneSelectionListener());
        new StructureSpeedSearch(this);
        this.enableDnD();
        this.setDesignSurface(designSurface);
        this.addMouseListener(new StructurePaneMouseListener());
    }

    private void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.setDragEnabled(true);
            this.setTransferHandler(new TreeTransferHandler());
            this.setDropTarget(new DropTarget((Component)((Object)this), new NlDropListener(this)));
        }
    }

    public void setDesignSurface(@Nullable DesignSurface designSurface) {
        this.setScreenView(designSurface != null ? designSurface.getCurrentScreenView() : null);
    }

    private void setScreenView(@Nullable ScreenView screenView) {
        this.myScreenView = screenView;
        this.setModel(screenView != null ? screenView.getModel() : null);
    }

    @Nullable
    public ScreenView getScreenView() {
        return this.myScreenView;
    }

    private void setModel(@Nullable NlModel model) {
        if (this.myModel != null) {
            this.myModel.removeListener(this);
            this.myModel.getSelectionModel().removeListener(this);
        }
        this.myModel = model;
        if (this.myModel != null) {
            this.myModel.addListener(this);
            this.myModel.getSelectionModel().addListener(this);
        }
        this.updateHierarchy();
    }

    @Nullable
    public NlModel getDesignerModel() {
        return this.myModel;
    }

    public void dispose() {
        if (this.myModel != null) {
            this.myModel.removeListener(this);
            this.myModel.getSelectionModel().removeListener(this);
            this.myModel = null;
        }
        Disposer.dispose((Disposable)this.myUpdateQueue);
    }

    private void createCellRenderer() {
        ColoredTreeCellRenderer renderer = new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/uibuilder/structure/NlComponentTree$1", "customizeCellRenderer"));
                }
                if (value instanceof NlComponent) {
                    StructureTreeDecorator.decorate((ColoredTextContainer)this, (NlComponent)value);
                }
            }
        };
        renderer.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setCellRenderer((TreeCellRenderer)renderer);
    }

    private void invalidateUI() {
        IJSwingUtilities.updateComponentTreeUI((Component)((Object)this));
    }

    private void updateHierarchy() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.setPaintBusy(true);
        this.myUpdateQueue.queue(new Update("updateComponentStructure"){

            public void run() {
                try {
                    if (NlComponentTree.this.myModel == null) {
                        return;
                    }
                    NlComponentTree.this.mySelectionIsUpdating.set(true);
                    Collection components = NlComponentTree.this.getCollapsedComponents();
                    NlComponentTree.this.setModel(new NlComponentTreeModel(NlComponentTree.this.myModel));
                    NlComponentTree.this.collapseComponents(components);
                    NlComponentTree.this.invalidateUI();
                }
                finally {
                    NlComponentTree.this.setPaintBusy(false);
                    NlComponentTree.this.mySelectionIsUpdating.set(false);
                }
                NlComponentTree.this.updateSelection();
            }
        });
        if (this.mySkipWait) {
            this.mySkipWait = false;
            this.myUpdateQueue.flush();
        }
    }

    @NotNull
    private Collection<NlComponent> getCollapsedComponents() {
        int rowCount = this.getRowCount();
        HashSet components = Sets.newHashSetWithExpectedSize((int)rowCount);
        for (int row = 0; row < rowCount; ++row) {
            NlComponent component;
            if (!this.isCollapsed(row) || (component = (NlComponent)this.getPathForRow(row).getLastPathComponent()).getChildCount() == 0) continue;
            components.add(component);
        }
        HashSet hashSet = components;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "getCollapsedComponents"));
        }
        return hashSet;
    }

    private void collapseComponents(@NotNull Collection<NlComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "collapseComponents"));
        }
        NlComponent root = (NlComponent)this.getModel().getRoot();
        if (root == null) {
            return;
        }
        this.expandAll(root);
        components.stream().forEach(component -> this.collapsePath(NlComponentTree.newTreePath(component)));
    }

    private void expandAll(@NotNull NlComponent parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "expandAll"));
        }
        if (parent.getChildren().stream().allMatch(child -> child.getChildCount() == 0)) {
            this.expandPath(NlComponentTree.newTreePath(parent));
        } else {
            parent.getChildren().stream().forEach(this::expandAll);
        }
    }

    void skipNextUpdateDelay() {
        this.mySkipWait = true;
    }

    private void updateSelection() {
        if (!this.mySelectionIsUpdating.compareAndSet(false, true)) {
            return;
        }
        try {
            this.clearSelection();
            if (this.myModel != null) {
                for (NlComponent component : this.myModel.getSelectionModel().getSelection()) {
                    this.addSelectionPath(NlComponentTree.newTreePath(component));
                }
            }
        }
        finally {
            this.mySelectionIsUpdating.set(false);
        }
    }

    @NotNull
    private static TreePath newTreePath(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "newTreePath"));
        }
        ArrayList<NlComponent> components = new ArrayList<NlComponent>();
        components.add(component);
        for (NlComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            components.add(parent);
        }
        Collections.reverse(components);
        TreePath treePath = new TreePath(components.toArray());
        if (treePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "newTreePath"));
        }
        return treePath;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.myInsertionPath != null) {
            this.paintInsertionPoint(g);
        }
    }

    private void paintInsertionPoint(Graphics g) {
        if (this.myInsertionPath != null) {
            Rectangle pathBounds = this.getPathBounds(this.myInsertionPath);
            if (pathBounds == null) {
                return;
            }
            int y = pathBounds.y;
            switch (this.myInsertionPoint) {
                case INSERT_BEFORE: {
                    break;
                }
                case INSERT_AFTER: {
                    y += pathBounds.height;
                    break;
                }
                case INSERT_INTO: {
                    y += pathBounds.height / 2;
                }
            }
            Rectangle bounds = this.getBounds();
            Polygon triangle = new Polygon();
            triangle.addPoint(bounds.x + 6, y);
            triangle.addPoint(bounds.x, y + 3);
            triangle.addPoint(bounds.x, y - 3);
            g.setColor(UIUtil.getTreeForeground());
            if (this.myInsertionPoint != InsertionPoint.INSERT_INTO) {
                g.drawLine(bounds.x, y, bounds.x + bounds.width, y);
            }
            g.drawPolygon(triangle);
            g.fillPolygon(triangle);
        }
    }

    public void markInsertionPoint(@Nullable TreePath path, @NotNull InsertionPoint insertionPoint) {
        if (insertionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertionPoint", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "markInsertionPoint"));
        }
        if (this.myInsertionPath != path || this.myInsertionPoint != insertionPoint) {
            this.myInsertionPath = path;
            this.myInsertionPoint = insertionPoint;
            this.repaint();
        }
    }

    protected void clearToggledPaths() {
        super.clearToggledPaths();
    }

    public List<NlComponent> getSelectedComponents() {
        ArrayList<NlComponent> selected = new ArrayList<NlComponent>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                selected.add((NlComponent)path.getLastPathComponent());
            }
        }
        return selected;
    }

    @Override
    public void selectionChanged(@NotNull SelectionModel model, @NotNull List<NlComponent> selection) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "selectionChanged"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "selectionChanged"));
        }
        UIUtil.invokeLaterIfNeeded(this::updateSelection);
    }

    @Override
    public void modelChanged(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "modelChanged"));
        }
        UIUtil.invokeLaterIfNeeded(this::updateHierarchy);
    }

    @Override
    public void modelRendered(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "modelRendered"));
        }
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface, @NotNull List<NlComponent> newSelection) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "componentSelectionChanged"));
        }
        if (newSelection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSelection", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "componentSelectionChanged"));
        }
    }

    @Override
    public void screenChanged(@NotNull DesignSurface surface, @Nullable ScreenView screenView) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "screenChanged"));
        }
        this.setScreenView(screenView);
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "modelChanged"));
        }
        if (model != null) {
            this.modelRendered(model);
        }
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "activatePreferredEditor"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "activatePreferredEditor"));
        }
        return false;
    }

    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "canDeleteElement"));
        }
        return true;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/structure/NlComponentTree", "deleteElement"));
        }
        SelectionModel selectionModel = this.myScreenView.getSelectionModel();
        NlModel model = this.myScreenView.getModel();
        this.skipNextUpdateDelay();
        model.delete(selectionModel.getSelection());
    }

    private static final class StructureSpeedSearch
    extends TreeSpeedSearch {
        StructureSpeedSearch(@NotNull NlComponentTree tree) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/uibuilder/structure/NlComponentTree$StructureSpeedSearch", "<init>"));
            }
            super((JTree)((Object)tree));
        }

        protected boolean isMatchingElement(Object element, String pattern) {
            if (pattern == null) {
                return false;
            }
            Object component = ((TreePath)element).getLastPathComponent();
            return this.compare(component instanceof NlComponent ? StructureTreeDecorator.toString((NlComponent)component) : "", pattern);
        }
    }

    private class StructurePaneSelectionListener
    implements TreeSelectionListener {
        private StructurePaneSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (!NlComponentTree.this.mySelectionIsUpdating.compareAndSet(false, true)) {
                return;
            }
            try {
                NlComponentTree.this.myModel.getSelectionModel().setSelection(NlComponentTree.this.getSelectedComponents());
            }
            finally {
                NlComponentTree.this.mySelectionIsUpdating.set(false);
            }
        }
    }

    private class StructurePaneMouseListener
    extends MouseAdapter {
        private StructurePaneMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handlePopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handlePopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handlePopup(e);
        }

        private void handlePopup(MouseEvent e) {
            Object component;
            TreePath path;
            if (e.isPopupTrigger() && (path = NlComponentTree.this.getPathForLocation(e.getX(), e.getY())) != null && (component = path.getLastPathComponent()) instanceof NlComponent) {
                NlComponentTree.this.myScreenView.getSurface().getActionManager().showPopup(e, NlComponentTree.this.myScreenView, (NlComponent)component);
            }
        }
    }

    static enum InsertionPoint {
        INSERT_INTO,
        INSERT_BEFORE,
        INSERT_AFTER;

    }
}

