/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class SuppressLintIntentionAction
implements IntentionAction,
Iconable {
    private static final String NO_INSPECTION_PREFIX = "//noinspection ";
    private final String myId;
    private final PsiElement myElement;

    public SuppressLintIntentionAction(String id, PsiElement element) {
        this.myId = id;
        this.myElement = element;
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return AllIcons.Actions.Cancel;
    }

    @NotNull
    public String getText() {
        String id = SuppressLintIntentionAction.getLintId(this.myId);
        PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiFile.class);
        if (file == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/SuppressLintIntentionAction", "getText"));
            }
            return "";
        }
        if (file instanceof XmlFile) {
            String string = AndroidBundle.message("android.lint.fix.suppress.lint.api.attr", id);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/SuppressLintIntentionAction", "getText"));
            }
            return string;
        }
        if (file instanceof PsiJavaFile) {
            String string = AndroidBundle.message("android.lint.fix.suppress.lint.api.annotation", id);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/SuppressLintIntentionAction", "getText"));
            }
            return string;
        }
        if (file instanceof GroovyFile) {
            String string = "Suppress: Add //noinspection " + id;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/SuppressLintIntentionAction", "getText"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/SuppressLintIntentionAction", "getText"));
        }
        return "";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/SuppressLintIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/lint/SuppressLintIntentionAction", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        Document document;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/lint/SuppressLintIntentionAction", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/inspections/lint/SuppressLintIntentionAction", "invoke"));
        }
        if (file instanceof XmlFile) {
            XmlTag element = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class);
            if (element == null) {
                return;
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)element)) {
                return;
            }
            String lintId = SuppressLintIntentionAction.getLintId(this.myId);
            SuppressLintIntentionAction.addSuppressAttribute(project, (XmlFile)file, element, lintId);
        } else if (file instanceof PsiJavaFile) {
            PsiModifierListOwner container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiModifierListOwner.class);
            if (container == null) {
                return;
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)container)) {
                return;
            }
            PsiModifierList modifierList = container.getModifierList();
            if (modifierList != null) {
                String lintId = SuppressLintIntentionAction.getLintId(this.myId);
                SuppressLintIntentionAction.addSuppressAnnotation(project, (PsiElement)container, container, lintId);
            }
        } else if (file instanceof GroovyFile && (document = PsiDocumentManager.getInstance((Project)this.myElement.getProject()).getDocument(file)) != null) {
            int nonSpace;
            int prevLineEnd;
            int prevLineStart;
            String prevLine;
            int index;
            int offset = this.myElement.getTextOffset();
            int line = document.getLineNumber(offset);
            int lineStart = document.getLineStartOffset(line);
            if (lineStart > 0 && (index = (prevLine = document.getText(new TextRange(prevLineStart = document.getLineStartOffset(line - 1), prevLineEnd = document.getLineEndOffset(line - 1)))).indexOf(NO_INSPECTION_PREFIX)) != -1) {
                document.insertString(prevLineStart + index + NO_INSPECTION_PREFIX.length(), (CharSequence)(SuppressLintIntentionAction.getLintId(this.myId) + ","));
                return;
            }
            String linePrefix = document.getText(new TextRange(lineStart, offset));
            for (nonSpace = 0; nonSpace < linePrefix.length() && Character.isWhitespace(linePrefix.charAt(nonSpace)); ++nonSpace) {
            }
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            document.insertString(lineStart + nonSpace, (CharSequence)(NO_INSPECTION_PREFIX + SuppressLintIntentionAction.getLintId(this.myId) + "\n" + linePrefix.substring(0, nonSpace)));
        }
    }

    static String getLintId(String intentionId) {
        String lintId = intentionId;
        if (lintId.startsWith("AndroidLint")) {
            lintId = lintId.substring("AndroidLint".length());
        }
        return lintId;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void addSuppressAttribute(Project project, XmlFile file, XmlTag element, String id) throws IncorrectOperationException {
        String value;
        XmlAttribute attribute = element.getAttribute("ignore", "http://schemas.android.com/tools");
        if (attribute == null) {
            value = id;
        } else {
            ArrayList<String> ids = new ArrayList<String>();
            for (String existing : Splitter.on((char)',').trimResults().split((CharSequence)attribute.getValue())) {
                if (existing.equals(id)) continue;
                ids.add(existing);
            }
            ids.add(id);
            Collections.sort(ids);
            value = Joiner.on((char)',').join(ids);
        }
        AndroidResourceUtil.ensureNamespaceImported(file, "http://schemas.android.com/tools", null);
        element.setAttribute("ignore", "http://schemas.android.com/tools", value);
    }

    private static void addSuppressAnnotation(Project project, PsiElement container, PsiModifierListOwner modifierOwner, String id) throws IncorrectOperationException {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierOwner, (String[])new String[]{"android.annotation.SuppressLint"});
        PsiAnnotation newAnnotation = SuppressLintIntentionAction.createNewAnnotation(project, container, annotation, id);
        if (newAnnotation != null) {
            if (annotation != null && annotation.isPhysical()) {
                annotation.replace((PsiElement)newAnnotation);
            } else {
                PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
                new AddAnnotationFix("android.annotation.SuppressLint", modifierOwner, attributes, new String[0]).invoke(project, null, container.getContainingFile());
            }
        }
    }

    @Nullable
    private static PsiAnnotation createNewAnnotation(@NotNull Project project, @NotNull PsiElement container, @Nullable PsiAnnotation annotation, @NotNull String id) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/lint/SuppressLintIntentionAction", "createNewAnnotation"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/android/inspections/lint/SuppressLintIntentionAction", "createNewAnnotation"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/android/inspections/lint/SuppressLintIntentionAction", "createNewAnnotation"));
        }
        if (annotation != null) {
            String currentSuppressedId = "\"" + id + "\"";
            String annotationText = annotation.getText();
            if (!annotationText.contains("{")) {
                PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
                if (attributes.length == 1) {
                    String suppressedWarnings = attributes[0].getText();
                    if (suppressedWarnings.contains(currentSuppressedId)) {
                        return null;
                    }
                    return JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@android.annotation.SuppressLint({" + suppressedWarnings + ", " + currentSuppressedId + "})", container);
                }
            } else {
                int curlyBraceIndex = annotationText.lastIndexOf("}");
                if (curlyBraceIndex > 0) {
                    String oldSuppressWarning = annotationText.substring(0, curlyBraceIndex);
                    if (oldSuppressWarning.contains(currentSuppressedId)) {
                        return null;
                    }
                    return JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText(oldSuppressWarning + ", " + currentSuppressedId + "})", container);
                }
            }
        } else {
            return JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@android.annotation.SuppressLint(\"" + id + "\")", container);
        }
        return null;
    }
}

