/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.editor.reference;

import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.model.xml.JndiEnvironmentRefsGroup;
import com.intellij.javaee.model.xml.ResourceRef;
import com.intellij.javaee.oss.editor.JavaeeSectionInfo;
import com.intellij.javaee.oss.editor.JavaeeSectionInfoEditable;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.editor.reference.JBossReferenceSection;
import com.intellij.javaee.oss.jboss.editor.reference.JBossReferenceUtil;
import com.intellij.javaee.oss.jboss.model.JBossReferenceHolder;
import com.intellij.javaee.oss.jboss.model.JBossResourceRef;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class JBossResourceRefSection
extends JBossReferenceSection<ResourceRef> {
    private final JndiEnvironmentRefsGroup group;
    private final JBossReferenceHolder holder;

    JBossResourceRefSection(JndiEnvironmentRefsGroup group, JBossReferenceHolder holder) {
        this.group = group;
        this.holder = holder;
    }

    public List<ResourceRef> getValues() {
        return this.group == null ? Collections.emptyList() : this.group.getResourceRefs();
    }

    @Override
    JavaeeSectionInfo<ResourceRef> createFirstColumn() {
        return new JavaeeSectionInfo<ResourceRef>(JBossBundle.getText("JBossReferenceEditor.resource", new Object[0])){

            public String valueOf(ResourceRef source) {
                return (String)source.getResRefName().getValue();
            }
        };
    }

    @Override
    JavaeeSectionInfo<ResourceRef> createSecondColumn() {
        return new JavaeeSectionInfoEditable<ResourceRef>(JBossBundle.getText("JBossReferenceEditor.jndi.name", new Object[0]), (JavaeeDomModelElement)this.holder){

            @Nullable
            public String valueOf(ResourceRef source) {
                JBossResourceRef target = JBossReferenceUtil.findResourceRef(JBossResourceRefSection.this.holder, source);
                return target == null ? null : (String)target.getJndiName().getValue();
            }

            protected void write(ResourceRef item, String value) {
                JBossResourceRef target = JBossReferenceUtil.findResourceRef(JBossResourceRefSection.this.holder, item);
                if (!StringUtil.isEmpty((String)value)) {
                    if (target == null) {
                        target = JBossResourceRefSection.this.holder.addResourceRef();
                        target.getResRefName().setValue((Object)item);
                    }
                    target.getJndiName().setValue((Object)value);
                } else if (target != null) {
                    target.undefine();
                }
            }
        };
    }
}

