/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.model.run;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.JpsAndroidPackagingOptions;
import com.intellij.flex.model.bc.JpsFlexBuildConfiguration;
import com.intellij.flex.model.bc.JpsFlexBuildConfigurationManager;
import com.intellij.flex.model.bc.JpsFlexCompilerOptions;
import com.intellij.flex.model.bc.JpsFlexDependencyEntry;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.run.JpsBCBasedRunnerParameters;
import com.intellij.openapi.util.io.FileUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsProject;

public class JpsFlashRunnerParameters
extends JpsBCBasedRunnerParameters<JpsFlashRunnerParameters> {
    private boolean myOverrideMainClass = false;
    @NotNull
    private String myOverriddenMainClass = "";
    @NotNull
    private String myOverriddenOutputFileName = "";

    public JpsFlashRunnerParameters() {
    }

    private JpsFlashRunnerParameters(JpsFlashRunnerParameters original) {
        this.myOverrideMainClass = original.myOverrideMainClass;
        this.myOverriddenMainClass = original.myOverriddenMainClass;
        this.myOverriddenOutputFileName = original.myOverriddenOutputFileName;
    }

    @NotNull
    public JpsFlashRunnerParameters createCopy() {
        JpsFlashRunnerParameters jpsFlashRunnerParameters = new JpsFlashRunnerParameters(this);
        if (jpsFlashRunnerParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/run/JpsFlashRunnerParameters", "createCopy"));
        }
        return jpsFlashRunnerParameters;
    }

    @Override
    public void applyChanges(@NotNull JpsFlashRunnerParameters modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "com/intellij/flex/model/run/JpsFlashRunnerParameters", "applyChanges"));
        }
        super.applyChanges(modified);
        this.myOverrideMainClass = modified.myOverrideMainClass;
        this.myOverriddenMainClass = modified.myOverriddenMainClass;
        this.myOverriddenOutputFileName = modified.myOverriddenOutputFileName;
    }

    public boolean isOverrideMainClass() {
        return this.myOverrideMainClass;
    }

    public void setOverrideMainClass(boolean overrideMainClass) {
        this.myOverrideMainClass = overrideMainClass;
    }

    @NotNull
    public String getOverriddenMainClass() {
        String string = this.myOverriddenMainClass;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/run/JpsFlashRunnerParameters", "getOverriddenMainClass"));
        }
        return string;
    }

    public void setOverriddenMainClass(@NotNull String overriddenMainClass) {
        if (overriddenMainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenMainClass", "com/intellij/flex/model/run/JpsFlashRunnerParameters", "setOverriddenMainClass"));
        }
        this.myOverriddenMainClass = overriddenMainClass;
    }

    @NotNull
    public String getOverriddenOutputFileName() {
        String string = this.myOverriddenOutputFileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/run/JpsFlashRunnerParameters", "getOverriddenOutputFileName"));
        }
        return string;
    }

    public void setOverriddenOutputFileName(@NotNull String overriddenOutputFileName) {
        if (overriddenOutputFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenOutputFileName", "com/intellij/flex/model/run/JpsFlashRunnerParameters", "setOverriddenOutputFileName"));
        }
        this.myOverriddenOutputFileName = overriddenOutputFileName;
    }

    @Override
    @Nullable
    public JpsFlexBuildConfiguration getBC(JpsProject project) {
        JpsFlexBuildConfiguration origBC = super.getBC(project);
        if (this.myOverrideMainClass && origBC != null) {
            JpsFlexBuildConfiguration overriddenBC = ((JpsFlexBuildConfigurationManager)origBC.getModule().getProperties()).createTemporaryCopyForCompilation(origBC);
            overriddenBC.setOutputType(OutputType.Application);
            overriddenBC.setMainClass(this.myOverriddenMainClass);
            overriddenBC.setOutputFileName(this.myOverriddenOutputFileName);
            overriddenBC.setRLMs(Collections.<JpsFlexBuildConfiguration.RLMInfo>emptyList());
            if (origBC.getOutputType() != OutputType.Application) {
                overriddenBC.setUseHtmlWrapper(false);
                overriddenBC.setCssFilesToCompile(Collections.<String>emptyList());
                overriddenBC.getDependencies().setFrameworkLinkage(LinkageType.Merged);
                for (JpsFlexDependencyEntry entry : overriddenBC.getDependencies().getEntries()) {
                    if (entry.getLinkageType() != LinkageType.External) continue;
                    entry.setLinkageType(LinkageType.Merged);
                }
                overriddenBC.getAirDesktopPackagingOptions().setUseGeneratedDescriptor(true);
                JpsAndroidPackagingOptions androidOptions = overriddenBC.getAndroidPackagingOptions();
                androidOptions.setEnabled(true);
                androidOptions.setUseGeneratedDescriptor(true);
                androidOptions.getSigningOptions().setUseTempCertificate(true);
                overriddenBC.getIosPackagingOptions().setEnabled(false);
            }
            if (FlexCommonUtils.canHaveResourceFiles(overriddenBC.getNature()) && !FlexCommonUtils.canHaveResourceFiles(origBC.getNature())) {
                overriddenBC.getCompilerOptions().setResourceFilesMode(JpsFlexCompilerOptions.ResourceFilesMode.None);
            }
            overriddenBC.getAndroidPackagingOptions().setPackageFileName(FileUtil.getNameWithoutExtension((String)this.myOverriddenOutputFileName));
            overriddenBC.getIosPackagingOptions().setPackageFileName(FileUtil.getNameWithoutExtension((String)this.myOverriddenOutputFileName));
            return overriddenBC;
        }
        return origBC;
    }
}

