/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.MacroAwareTextBrowseFolderListener;
import com.intellij.ui.TextAccessor;
import com.intellij.util.PathUtil;
import com.jetbrains.javascript.debugger.execution.DebuggableProcessRunConfigurationBase;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggableProcessRunConfigurationEditor<T extends DebuggableProcessRunConfigurationBase>
extends SettingsEditor<T> {
    protected DebuggableProgramParametersPanel panel;
    private final Project project;

    public DebuggableProcessRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationEditor", "<init>"));
        }
        this.project = project;
    }

    protected void resetEditorFrom(@NotNull T configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationEditor", "resetEditorFrom"));
        }
        this.panel.reset((CommonProgramRunConfigurationParameters)configuration);
    }

    protected void applyEditorTo(T configuration) throws ConfigurationException {
        this.panel.applyTo((CommonProgramRunConfigurationParameters)configuration);
    }

    @NotNull
    protected DebuggableProgramParametersPanel createEditor() {
        this.panel = new DebuggableProgramParametersPanel(this.project);
        this.panel.inputPathTextField.addBrowseFolderListener((TextBrowseFolderListener)new MacroAwareTextBrowseFolderListener(this.createInputPathDescriptor(), this.project));
        this.panel.exePathTextField.addBrowseFolderListener((TextBrowseFolderListener)new MacroAwareTextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor(), this.project));
        DebuggableProgramParametersPanel debuggableProgramParametersPanel = this.panel;
        if (debuggableProgramParametersPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationEditor", "createEditor"));
        }
        return debuggableProgramParametersPanel;
    }

    protected FileChooserDescriptor createInputPathDescriptor() {
        return FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
    }

    protected static class DebuggableProgramParametersPanel
    extends CommonProgramParametersPanel {
        private final Project project;
        private LabeledComponent<JComponent> exePathComponent;
        private LabeledComponent<JComponent> inputPathComponent;
        private TextFieldWithBrowseButton exePathTextField;
        private TextFieldWithBrowseButton inputPathTextField;
        private final PathMacroManager pathMacroManager;

        public DebuggableProgramParametersPanel(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationEditor$DebuggableProgramParametersPanel", "<init>"));
            }
            super(false);
            this.project = project;
            this.pathMacroManager = PathMacroManager.getInstance((ComponentManager)this.getProject());
            this.init();
        }

        @NotNull
        protected Project getProject() {
            Project project = this.project;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationEditor$DebuggableProgramParametersPanel", "getProject"));
            }
            return project;
        }

        protected void addComponents() {
            this.inputPathTextField = new TextFieldWithBrowseButton();
            this.inputPathComponent = LabeledComponent.create((JComponent)this.createComponentWithMacroBrowse(this.inputPathTextField), (String)"File:");
            this.exePathTextField = new TextFieldWithBrowseButton();
            this.exePathComponent = LabeledComponent.create((JComponent)this.createComponentWithMacroBrowse(this.exePathTextField), (String)"");
            this.inputPathComponent.setLabelLocation("West");
            this.exePathComponent.setLabelLocation("West");
            this.add((Component)this.inputPathComponent);
            super.addComponents();
            this.add((Component)this.exePathComponent);
        }

        public DebuggableProgramParametersPanel inputPathLabel(@NotNull String label) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationEditor$DebuggableProgramParametersPanel", "inputPathLabel"));
            }
            this.inputPathComponent.setText(label);
            return this;
        }

        public DebuggableProgramParametersPanel programParametersLabel(@NotNull String label) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationEditor$DebuggableProgramParametersPanel", "programParametersLabel"));
            }
            this.setProgramParametersLabel(label);
            return this;
        }

        public DebuggableProgramParametersPanel exePathLabel(@NotNull String label) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationEditor$DebuggableProgramParametersPanel", "exePathLabel"));
            }
            this.exePathComponent.setText(label);
            return this;
        }

        public void setAnchor(JComponent anchor) {
            super.setAnchor(anchor);
            this.inputPathComponent.setAnchor(anchor);
            this.exePathComponent.setAnchor(anchor);
        }

        public void applyTo(CommonProgramRunConfigurationParameters c) {
            super.applyTo(c);
            DebuggableProcessRunConfigurationBase configuration = (DebuggableProcessRunConfigurationBase)c;
            configuration.setInputPath(this.fromTextField((TextAccessor)this.inputPathTextField, configuration));
            configuration.setExePath(this.fromTextField((TextAccessor)this.exePathTextField, configuration));
        }

        public void reset(CommonProgramRunConfigurationParameters c) {
            super.reset(c);
            DebuggableProcessRunConfigurationBase configuration = (DebuggableProcessRunConfigurationBase)c;
            this.inputPathTextField.setText(this.pathToTextField(configuration.getInputPath()));
            this.setProgramParameters(this.pathMacroManager.collapsePath(configuration.getProgramParameters()));
            String workingDirectory = this.pathToTextField(configuration.getWorkingDirectory());
            if (workingDirectory == null) {
                workingDirectory = this.project.getBasePath();
            }
            this.setWorkingDirectory(workingDirectory);
            String exePath = this.pathToTextField(configuration.getExePath());
            if (exePath == null) {
                exePath = configuration.computeDefaultExePath();
            }
            this.exePathTextField.setText(exePath);
        }

        private String pathToTextField(@Nullable String path) {
            if ((path = PathUtil.toSystemDependentName((String)path)) == null || !path.contains("PROJECT_DIR") || this.project.isDefault()) {
                return path;
            }
            ExpandMacroToPathMap map = new ExpandMacroToPathMap();
            map.addMacroExpand("PROJECT_DIR", this.project.getBasePath());
            return map.substitute(path, false);
        }

        @Nullable
        protected String fromTextField(@NotNull TextAccessor textAccessor, @NotNull CommonProgramRunConfigurationParameters c) {
            if (textAccessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textAccessor", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationEditor$DebuggableProgramParametersPanel", "fromTextField"));
            }
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfigurationEditor$DebuggableProgramParametersPanel", "fromTextField"));
            }
            String path = StringUtil.nullize((String)super.fromTextField(textAccessor, c), (boolean)true);
            if (path == null) {
                return null;
            }
            if (textAccessor != this.getProgramParametersComponent().getComponent()) {
                DebuggableProcessRunConfigurationBase configuration = (DebuggableProcessRunConfigurationBase)c;
                if (textAccessor == this.exePathTextField ? path.equals(configuration.computeDefaultExePath()) : textAccessor == this.myWorkingDirectoryField && path.equals(this.project.getBasePath())) {
                    return null;
                }
                path = PathUtil.toSystemIndependentName((String)path);
            }
            return this.pathMacroManager.collapsePath(path);
        }
    }
}

