/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.util.Function;
import com.jetbrains.javascript.debugger.execution.DebuggableRunProfileState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.DebuggableRunConfiguration;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u001c\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ!\u0010\u001b\u001a\u0015\u0012\f\u0012\n \"*\u0004\u0018\u00010\u00180\u00180!\u00a2\u0006\u0002\b#2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0!H\u0014J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH$R\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"Lcom/jetbrains/javascript/debugger/execution/DebuggableProcessStateBase;", "T", "Lorg/jetbrains/debugger/DebuggableRunConfiguration;", "Lcom/jetbrains/javascript/debugger/execution/DebuggableRunProfileState;", "configuration", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lorg/jetbrains/debugger/DebuggableRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "getConfiguration", "()Lorg/jetbrains/debugger/DebuggableRunConfiguration;", "Lorg/jetbrains/debugger/DebuggableRunConfiguration;", "getEnvironment", "()Lcom/intellij/execution/runners/ExecutionEnvironment;", "addConsoleFilters", "", "builder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "createConsole", "Lcom/intellij/execution/ui/ConsoleView;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "isDebug", "", "createExecutionResult", "Lcom/intellij/execution/ExecutionResult;", "debugPort", "", "execute", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "Lorg/jetbrains/concurrency/Promise;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "prepareDebug", "", "startProcess", "JavaScriptDebugger"})
public abstract class DebuggableProcessStateBase<T extends DebuggableRunConfiguration>
implements DebuggableRunProfileState {
    @NotNull
    private final T configuration;
    @NotNull
    private final ExecutionEnvironment environment;

    @NotNull
    public final ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<RunnerSettings> runner) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
        return this.createExecutionResult(-1);
    }

    @Override
    @NotNull
    public final Promise<ExecutionResult> execute(int debugPort) {
        return this.prepareDebug().then((Function)new Function<Object, ExecutionResult>(this, debugPort){
            final /* synthetic */ DebuggableProcessStateBase this$0;
            final /* synthetic */ int $debugPort;

            @NotNull
            public final ExecutionResult fun(@Nullable Object it) {
                return this.this$0.createExecutionResult(this.$debugPort);
            }
            {
                this.this$0 = debuggableProcessStateBase;
                this.$debugPort = n;
            }
        });
    }

    @NotNull
    protected ExecutionResult createExecutionResult(int debugPort) {
        ProcessHandler processHandler = this.startProcess(debugPort);
        return (ExecutionResult)new DefaultExecutionResult((ExecutionConsole)this.createConsole(processHandler, debugPort != -1), processHandler);
    }

    @NotNull
    protected abstract ProcessHandler startProcess(int var1);

    private final ConsoleView createConsole(ProcessHandler processHandler, boolean isDebug) {
        ConsoleView console2;
        if (isDebug) {
            return null;
        }
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.environment.getProject());
        if (consoleBuilder instanceof TextConsoleBuilderImpl) {
            ((TextConsoleBuilderImpl)consoleBuilder).setUsePredefinedMessageFilter(true);
        }
        TextConsoleBuilder textConsoleBuilder = consoleBuilder;
        Intrinsics.checkExpressionValueIsNotNull((Object)textConsoleBuilder, (String)"consoleBuilder");
        this.addConsoleFilters(textConsoleBuilder);
        ConsoleView consoleView = console2 = consoleBuilder.getConsole();
        if (consoleView == null) {
            Intrinsics.throwNpe();
        }
        consoleView.attachToProcess(processHandler);
        return console2;
    }

    protected void addConsoleFilters(@NotNull TextConsoleBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
    }

    @NotNull
    protected Promise<Object> prepareDebug() {
        return Promises.resolvedPromise();
    }

    @NotNull
    protected final T getConfiguration() {
        return this.configuration;
    }

    @NotNull
    protected final ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    public DebuggableProcessStateBase(@NotNull T configuration, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        this.configuration = configuration;
        this.environment = environment;
    }
}

