/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.java.model.internal;

import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.reflect.annotation.EnumConstantNotPresentExceptionProxy;

public final class AnnotationUtil {
    public static final Map<PsiType, Class<?>> ARRAY_TYPES_MAP;

    public static Object createEnumValue(Class<?> enumClass, String name) {
        try {
            return Enum.valueOf(enumClass, name);
        }
        catch (IllegalArgumentException ex) {
            return new EnumConstantNotPresentExceptionProxy(enumClass, name);
        }
    }

    static {
        HashMap<PsiPrimitiveType, Class<Serializable>> classes = new HashMap<PsiPrimitiveType, Class<Serializable>>();
        classes.put(PsiType.BYTE, Byte.TYPE);
        classes.put(PsiType.SHORT, Short.TYPE);
        classes.put(PsiType.INT, Integer.TYPE);
        classes.put(PsiType.CHAR, Character.TYPE);
        classes.put(PsiType.BOOLEAN, Boolean.TYPE);
        classes.put(PsiType.LONG, Long.TYPE);
        classes.put(PsiType.FLOAT, Float.TYPE);
        classes.put(PsiType.DOUBLE, Double.TYPE);
        ARRAY_TYPES_MAP = Collections.unmodifiableMap(classes);
    }
}

