/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.markdown.injection.LanguageGuesser;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceContentImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeFenceInjector
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/intellij/plugins/markdown/injection/CodeFenceInjector", "getLanguagesToInject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/plugins/markdown/injection/CodeFenceInjector", "getLanguagesToInject"));
        }
        if (!(context instanceof MarkdownCodeFenceImpl)) {
            return;
        }
        if (PsiTreeUtil.findChildOfType((PsiElement)context, MarkdownCodeFenceContentImpl.class) == null) {
            return;
        }
        Language language = this.findLangForInjection((MarkdownCodeFenceImpl)context);
        if (language == null) {
            return;
        }
        registrar.startInjecting(language);
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)context, MarkdownCodeFenceContentImpl.class);
        for (int i = 0; i < list.size(); ++i) {
            MarkdownCodeFenceContentImpl content = (MarkdownCodeFenceContentImpl)((Object)list.get(i));
            boolean includeEol = i + 1 < list.size();
            TextRange rangeInHost = TextRange.from((int)content.getStartOffsetInParent(), (int)(content.getTextLength() + (includeEol ? 1 : 0)));
            registrar.addPlace(null, null, (PsiLanguageInjectionHost)((MarkdownCodeFenceImpl)context), rangeInHost);
        }
        registrar.doneInjecting();
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<MarkdownCodeFenceImpl>> list = Collections.singletonList(MarkdownCodeFenceImpl.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/injection/CodeFenceInjector", "elementsToInjectIn"));
        }
        return list;
    }

    @Nullable
    protected Language findLangForInjection(@NotNull MarkdownCodeFenceImpl element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/markdown/injection/CodeFenceInjector", "findLangForInjection"));
        }
        String fenceLanguage = element.getFenceLanguage();
        if (fenceLanguage == null) {
            return null;
        }
        return CodeFenceInjector.guessLanguageByFenceLang(fenceLanguage);
    }

    @Nullable
    private static Language guessLanguageByFenceLang(@NotNull String langName) {
        if (langName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "langName", "org/intellij/plugins/markdown/injection/CodeFenceInjector", "guessLanguageByFenceLang"));
        }
        return LanguageGuesser.INSTANCE.guessLanguage(langName);
    }
}

