/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.psi.tree.IElementType;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.ui.actions.styling.BaseToggleStateAction;
import org.jetbrains.annotations.NotNull;

public class ToggleItalicAction
extends BaseToggleStateAction {
    @Override
    @NotNull
    protected String getBoundString(@NotNull CharSequence text, int selectionStart, int selectionEnd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/plugins/markdown/ui/actions/styling/ToggleItalicAction", "getBoundString"));
        }
        String string = ToggleItalicAction.isWord(text, selectionStart, selectionEnd) ? "_" : "*";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/actions/styling/ToggleItalicAction", "getBoundString"));
        }
        return string;
    }

    @Override
    protected boolean shouldMoveToWordBounds() {
        return true;
    }

    @Override
    @NotNull
    protected IElementType getTargetNodeType() {
        IElementType iElementType = MarkdownElementTypes.EMPH;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/actions/styling/ToggleItalicAction", "getTargetNodeType"));
        }
        return iElementType;
    }

    private static boolean isWord(@NotNull CharSequence text, int from, int to) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/plugins/markdown/ui/actions/styling/ToggleItalicAction", "isWord"));
        }
        return !(from != 0 && Character.isLetterOrDigit(text.charAt(from - 1)) || to != text.length() && Character.isLetterOrDigit(text.charAt(to)));
    }
}

