/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleUrlProvider
implements SMTestLocator {
    public static final String PROTOCOL_ID = "gradle";
    public static final String METHOD_PREF = "methodName";
    public static final String CLASS_PREF = "className";
    public static final GradleUrlProvider INSTANCE = new GradleUrlProvider();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "org/jetbrains/plugins/gradle/execution/test/runner/GradleUrlProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/gradle/execution/test/runner/GradleUrlProvider", "getLocation"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/execution/test/runner/GradleUrlProvider", "getLocation"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/gradle/execution/test/runner/GradleUrlProvider", "getLocation"));
        }
        if (!PROTOCOL_ID.equals(protocol)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/GradleUrlProvider", "getLocation"));
            }
            return list;
        }
        String className = GradleUrlProvider.extractFullClassName(path);
        if (className == null) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/GradleUrlProvider", "getLocation"));
            }
            return list;
        }
        PsiClass testClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
        if (testClass == null) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/GradleUrlProvider", "getLocation"));
            }
            return list;
        }
        String methodName = GradleUrlProvider.extractMethodName(path);
        if (methodName == null) {
            List<PsiLocation> list = Collections.singletonList(new PsiLocation(project, (PsiElement)testClass));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/GradleUrlProvider", "getLocation"));
            }
            return list;
        }
        PsiMethod[] methods = testClass.findMethodsByName(methodName, true);
        ArrayList<Location> list = new ArrayList<Location>(methods.length);
        for (PsiMethod method : methods) {
            list.add((Location)new PsiLocation(project, (PsiElement)method));
        }
        ArrayList<Location> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/GradleUrlProvider", "getLocation"));
        }
        return arrayList;
    }

    @Nullable
    private static String extractFullClassName(String locationData) {
        int i = locationData.indexOf("::");
        String pref = locationData.substring(0, i);
        String qualifiedName = locationData.substring(i + 2);
        if (METHOD_PREF.equals(pref)) {
            int dot = qualifiedName.indexOf("::");
            return dot == -1 ? null : qualifiedName.substring(0, dot);
        }
        if (CLASS_PREF.equals(pref)) {
            return qualifiedName;
        }
        return null;
    }

    @Nullable
    private static String extractMethodName(String locationData) {
        int i = locationData.indexOf("::");
        String pref = locationData.substring(0, i);
        String qualifiedName = locationData.substring(i + 2);
        if (METHOD_PREF.equals(pref)) {
            int dot = qualifiedName.indexOf("::");
            return dot == -1 ? null : qualifiedName.substring(dot + 2);
        }
        return null;
    }
}

