/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleDistributionsContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.gradle.service.resolve.GradleSourceSetsContributor;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public class GradleRootContributor
implements GradleMethodContextContributor {
    private final GradleSourceSetsContributor mySourceSetsContributor;
    private final GradleDistributionsContributor myDistributionsContributor;
    private static final Set<String> BUILD_SCRIPT_BLOCKS = ContainerUtil.newHashSet((Object[])new String[]{"subprojects", "allprojects", "beforeEvaluate", "afterEvaluate", "sourceSets", "distributions"});

    public GradleRootContributor(GradleSourceSetsContributor sourceSetsContributor, GradleDistributionsContributor contributor) {
        this.mySourceSetsContributor = sourceSetsContributor;
        this.myDistributionsContributor = contributor;
    }

    @Override
    public void process(@NotNull List<String> methodCallInfo, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (methodCallInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallInfo", "org/jetbrains/plugins/gradle/service/resolve/GradleRootContributor", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleRootContributor", "process"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleRootContributor", "process"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleRootContributor", "process"));
        }
        if (methodCallInfo.size() > 2) {
            return;
        }
        if (methodCallInfo.size() == 2 && !BUILD_SCRIPT_BLOCKS.contains(methodCallInfo.get(1))) {
            return;
        }
        if (methodCallInfo.size() > 0) {
            String method = (String)ContainerUtil.getLastItem(methodCallInfo);
            if (method != null && StringUtil.startsWith((CharSequence)method, (CharSequence)"sourceSets")) {
                this.mySourceSetsContributor.process(methodCallInfo, processor, state, place);
                return;
            }
            if (method != null && StringUtil.startsWith((CharSequence)method, (CharSequence)"distributions")) {
                this.myDistributionsContributor.process(methodCallInfo, processor, state, place);
                return;
            }
        }
        GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
        GradleResolverUtil.processDeclarations(methodCallInfo.size() > 0 ? methodCallInfo.get(0) : null, psiManager, processor, state, place, "org.gradle.api.Project");
    }
}

