/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.SeparatePiecesRunner;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.integrate.ChangeListsMergerFactory;
import org.jetbrains.idea.svn.integrate.LocalChangesPromptTask;
import org.jetbrains.idea.svn.integrate.LookForBranchOriginTask;
import org.jetbrains.idea.svn.integrate.MergeAllWithBranchCopyPointTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.MergeTask;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.tmatesoft.svn.core.SVNURL;

public abstract class BaseMergeTask
extends TaskDescriptor {
    private static final Logger LOG = Logger.getInstance(BaseMergeTask.class);
    @NotNull
    protected final QuickMerge myMergeProcess;
    @NotNull
    protected final MergeContext myMergeContext;
    @NotNull
    protected final QuickMergeInteraction myInteraction;
    @NotNull
    private final SeparatePiecesRunner myRunner;

    public BaseMergeTask(@NotNull QuickMerge mergeProcess, @NotNull String name, @NotNull Where where) {
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "<init>"));
        }
        if (where == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "where", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "<init>"));
        }
        super(name, where);
        this.myMergeProcess = mergeProcess;
        this.myMergeContext = mergeProcess.getMergeContext();
        this.myInteraction = mergeProcess.getInteraction();
        this.myRunner = mergeProcess.getRunner();
    }

    protected boolean is18() {
        return this.myMergeContext.getWcInfo().getFormat().isOrGreater(WorkingCopyFormat.ONE_DOT_EIGHT);
    }

    public void run(@NotNull ContinuationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "run"));
        }
        try {
            this.run();
        }
        catch (VcsException e) {
            this.end(e);
        }
    }

    public void run() throws VcsException {
    }

    protected void next(TaskDescriptor ... tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "next"));
        }
        this.myRunner.next(tasks);
    }

    protected void next(@NotNull List<TaskDescriptor> tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "next"));
        }
        this.myRunner.next(tasks);
    }

    protected void suspend() {
        this.myRunner.suspend();
    }

    protected void ping() {
        this.myRunner.ping();
    }

    @NotNull
    protected List<TaskDescriptor> getMergeAllTasks(boolean supportsMergeInfo) {
        BaseMergeTask mergeAllTask = supportsMergeInfo && this.is18() ? new MergeAllWithBranchCopyPointTask(this.myMergeProcess) : new LookForBranchOriginTask(this.myMergeProcess, true, (Consumer<SvnBranchPointsCalculator.WrapperInvertor>)((Consumer)copyPoint -> this.next(new MergeAllWithBranchCopyPointTask(this.myMergeProcess, (SvnBranchPointsCalculator.WrapperInvertor)copyPoint, supportsMergeInfo))));
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new TaskDescriptor[]{new LocalChangesPromptTask(this.myMergeProcess), mergeAllTask});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "getMergeAllTasks"));
        }
        return arrayList;
    }

    protected void runChangeListsMerge(@NotNull List<CommittedChangeList> lists, @NotNull String title) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "runChangeListsMerge"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "runChangeListsMerge"));
        }
        this.next(new LocalChangesPromptTask(this.myMergeProcess, lists), new MergeTask(this.myMergeProcess, new ChangeListsMergerFactory(lists, false, false, true), title));
    }

    @Nullable
    protected SVNURL parseSourceUrl() {
        SVNURL result = null;
        try {
            result = SvnUtil.createUrl(this.myMergeContext.getSourceUrl());
        }
        catch (SvnBindException e) {
            this.end(e);
        }
        return result;
    }

    protected void end() {
        this.myRunner.cancelEverything();
    }

    protected void end(@NotNull String message, boolean isError) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "end"));
        }
        LOG.info((isError ? "Error: " : "Info: ") + message);
        this.end();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "lambda$end$1"));
            }
            this.myInteraction.showErrors(message, isError);
        });
    }

    protected void end(@NotNull VcsException e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "end"));
        }
        this.end(this.myMergeContext.getTitle(), e);
    }

    protected void end(@NotNull String message, @NotNull VcsException e) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "end"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "end"));
        }
        LOG.info(message, (Throwable)e);
        this.end();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "lambda$end$2"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/integrate/BaseMergeTask", "lambda$end$2"));
            }
            this.myInteraction.showErrors(message, Collections.singletonList(e));
        });
    }
}

