/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.util.continuation.Where;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.BranchMerger;
import org.jetbrains.idea.svn.integrate.MergeTask;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;

public class MergeAllWithBranchCopyPointTask
extends BaseMergeTask {
    @Nullable
    private final SvnBranchPointsCalculator.WrapperInvertor myCopyPoint;
    private final boolean mySupportsMergeInfo;

    public MergeAllWithBranchCopyPointTask(@NotNull QuickMerge mergeProcess) {
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/MergeAllWithBranchCopyPointTask", "<init>"));
        }
        super(mergeProcess, "merge all", Where.AWT);
        this.myCopyPoint = null;
        this.mySupportsMergeInfo = true;
    }

    public MergeAllWithBranchCopyPointTask(@NotNull QuickMerge mergeProcess, @NotNull SvnBranchPointsCalculator.WrapperInvertor copyPoint, boolean supportsMergeInfo) {
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/MergeAllWithBranchCopyPointTask", "<init>"));
        }
        if (copyPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyPoint", "org/jetbrains/idea/svn/integrate/MergeAllWithBranchCopyPointTask", "<init>"));
        }
        super(mergeProcess, "merge all", Where.AWT);
        this.myCopyPoint = copyPoint;
        this.mySupportsMergeInfo = supportsMergeInfo;
    }

    @Override
    public void run() {
        boolean reintegrate;
        boolean bl = reintegrate = this.myCopyPoint != null && this.myCopyPoint.isInvertedSense();
        if (reintegrate && !this.myInteraction.shouldReintegrate(this.myCopyPoint.inverted().getTarget())) {
            this.end();
        } else {
            MergerFactory mergerFactory = this.createBranchMergerFactory(reintegrate);
            String title = "Merging all from " + this.myMergeContext.getBranchName() + (reintegrate ? " (reintegrate)" : "");
            this.next(new MergeTask(this.myMergeProcess, mergerFactory, title));
        }
    }

    @NotNull
    private MergerFactory createBranchMergerFactory(boolean reintegrate) {
        MergerFactory mergerFactory = (vcs, target, handler, currentBranchUrl, branchName) -> {
            long revision = this.myCopyPoint != null ? (reintegrate ? this.myCopyPoint.getWrapped().getTargetRevision() : this.myCopyPoint.getWrapped().getSourceRevision()) : -1L;
            return new BranchMerger(vcs, currentBranchUrl, this.myMergeContext.getWcInfo().getPath(), handler, reintegrate, this.myMergeContext.getBranchName(), revision, this.mySupportsMergeInfo);
        };
        if (mergerFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeAllWithBranchCopyPointTask", "createBranchMergerFactory"));
        }
        return mergerFactory;
    }
}

