/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.ClassUtil;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGTestObject;
import com.theoryinpractice.testng.model.TestType;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.testng.TestNGXmlSuiteHelper;
import org.testng.xml.LaunchSuite;
import org.testng.xml.Parser;
import org.testng.xml.SuiteGenerator;
import org.testng.xml.XmlSuite;

public class SearchingForTestsTask
extends SearchForTestsTask {
    private static final Logger LOG = Logger.getInstance((String)("#" + SearchingForTestsTask.class.getName()));
    protected final Map<PsiClass, Map<PsiMethod, List<String>>> myClasses;
    private final TestData myData;
    private final Project myProject;
    private final TestNGConfiguration myConfig;
    private final File myTempFile;

    public SearchingForTestsTask(ServerSocket serverSocket, TestNGConfiguration config, File tempFile) {
        super(config.getProject(), serverSocket);
        this.myData = config.getPersistantData();
        this.myProject = config.getProject();
        this.myConfig = config;
        this.myTempFile = tempFile;
        this.myClasses = new LinkedHashMap<PsiClass, Map<PsiMethod, List<String>>>();
    }

    protected void onFound() {
        if (this.myClasses.size() > 0) {
            this.composeTestSuiteFromClasses();
        } else if (TestType.SUITE.getType().equals(this.myData.TEST_OBJECT)) {
            try {
                this.composeTestSuiteFromXml();
            }
            catch (CantRunException e) {
                this.logCantRunException((ExecutionException)e);
            }
        }
        try {
            FileUtil.writeToFile((File)this.myTempFile, (byte[])"end".getBytes(), (boolean)true);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void search() throws CantRunException {
        this.myClasses.clear();
        this.fillTestObjects(this.myClasses);
    }

    protected void logCantRunException(ExecutionException e) {
        try {
            String message = "CantRunException" + e.getMessage() + "\n";
            FileUtil.writeToFile((File)this.myTempFile, (byte[])message.getBytes());
        }
        catch (IOException e1) {
            LOG.error((Throwable)e1);
        }
    }

    private void composeTestSuiteFromClasses() {
        File xmlFile;
        LinkedHashMap<String, Map<String, List<String>>> map = new LinkedHashMap<String, Map<String, List<String>>>();
        boolean findTestMethodsForClass = this.shouldSearchForTestMethods();
        for (final Map.Entry<PsiClass, Map<PsiMethod, List<String>>> entry : this.myClasses.entrySet()) {
            String className;
            Map<PsiMethod, List<String>> depMethods = entry.getValue();
            LinkedHashMap<String, List<String>> methods = new LinkedHashMap<String, List<String>>();
            for (Map.Entry<PsiMethod, List<String>> method : depMethods.entrySet()) {
                methods.put(method.getKey().getName(), method.getValue());
            }
            if (findTestMethodsForClass && depMethods.isEmpty()) {
                for (PsiMethod method : entry.getKey().getMethods()) {
                    if (!TestNGUtil.hasTest((PsiModifierListOwner)method)) continue;
                    methods.put(method.getName(), Collections.emptyList());
                }
            }
            if ((className = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    return ClassUtil.getJVMClassName((PsiClass)((PsiClass)entry.getKey()));
                }
            })) == null) continue;
            map.put(className, methods);
        }
        Set<String> groupNames = this.myConfig.calculateGroupNames();
        Map<String, String> testParams = this.buildTestParameters();
        int logLevel = 1;
        try {
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(this.myConfig.getPersistantData().VM_PARAMETERS.getBytes()));
            String verbose = properties.getProperty("-Dtestng.verbose");
            if (verbose != null) {
                logLevel = Integer.parseInt(verbose);
            }
        }
        catch (Exception e) {
            logLevel = 1;
        }
        if (groupNames != null) {
            LinkedHashMap methodNames = new LinkedHashMap();
            for (Map.Entry entry : map.entrySet()) {
                methodNames.put(entry.getKey(), ((Map)entry.getValue()).keySet());
            }
            LaunchSuite suite = SuiteGenerator.createSuite((String)this.myProject.getName(), null, methodNames, groupNames, testParams, (String)"jdk", (int)logLevel);
            xmlFile = suite.save(new File(PathManager.getSystemPath()));
        } else {
            xmlFile = TestNGXmlSuiteHelper.writeSuite(map, testParams, this.myProject.getName(), PathManager.getSystemPath(), new TestNGXmlSuiteHelper.Logger(){

                @Override
                public void log(Throwable e) {
                    LOG.error(e);
                }
            });
        }
        String path = xmlFile.getAbsolutePath() + "\n";
        try {
            FileUtil.writeToFile((File)this.myTempFile, (byte[])path.getBytes(CharsetToolkit.UTF8_CHARSET), (boolean)true);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean shouldSearchForTestMethods() {
        for (Map<PsiMethod, List<String>> methods : this.myClasses.values()) {
            if (methods.isEmpty()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void composeTestSuiteFromXml() throws CantRunException {
        Map<String, String> buildTestParams = this.buildTestParameters();
        try {
            if (buildTestParams.isEmpty()) {
                String path = new File(this.myData.getSuiteName()).getAbsolutePath() + "\n";
                FileUtil.writeToFile((File)this.myTempFile, (byte[])path.getBytes(CharsetToolkit.UTF8_CHARSET), (boolean)true);
                return;
            }
            Parser parser = new Parser(this.myData.getSuiteName());
            parser.setLoadClasses(false);
            Collection suites = parser.parse();
            for (XmlSuite suite : suites) {
                Map params = suite.getParameters();
                params.putAll(buildTestParams);
                String fileId = FileUtil.sanitizeFileName((String)(this.myProject.getName() + '_' + suite.getName() + '_' + Integer.toHexString(suite.getName().hashCode()) + ".xml"));
                File suiteFile = new File(PathManager.getSystemPath(), fileId);
                try (FileWriter fileWriter = new FileWriter(suiteFile);){
                    fileWriter.write(suite.toXml());
                }
                String path = suiteFile.getAbsolutePath() + "\n";
                FileUtil.writeToFile((File)this.myTempFile, (byte[])path.getBytes(CharsetToolkit.UTF8_CHARSET), (boolean)true);
            }
        }
        catch (Exception e) {
            throw new CantRunException("Unable to parse suite: " + e.getMessage());
        }
    }

    protected void fillTestObjects(Map<PsiClass, Map<PsiMethod, List<String>>> classes) throws CantRunException {
        TestNGTestObject testObject = TestNGTestObject.fromConfig(this.myConfig);
        if (testObject != null) {
            testObject.fillTestObjects(classes);
        }
    }

    private Map<String, String> buildTestParameters() {
        File propertiesFile;
        HashMap<String, String> testParams = new HashMap<String, String>();
        if (this.myData.PROPERTIES_FILE != null && (propertiesFile = new File(this.myData.PROPERTIES_FILE)).exists()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(propertiesFile));
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    testParams.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        testParams.putAll(this.myData.TEST_PROPERTIES);
        return testParams;
    }
}

