/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.model.converters;

import com.intellij.batch.inspections.RequiredArtifactTypeInspection;
import com.intellij.batch.model.BatchArtifactRefBean;
import com.intellij.batch.utils.BatchCommonUtils;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchArtifactRefConverter
extends ResolvingConverter<BatchArtifactRefBean>
implements CustomReferenceConverter<BatchArtifactRefBean> {
    @Nullable
    public BatchArtifactRefBean fromString(@Nullable @NonNls String s, ConvertContext context) {
        Module module = context.getModule();
        if (s != null && module != null) {
            Set<BatchArtifactRefBean> refs = BatchCommonUtils.getBatchArtifactRefs(module);
            for (BatchArtifactRefBean ref : refs) {
                if (!s.equals(ref.getName())) continue;
                return ref;
            }
        }
        return null;
    }

    @Nullable
    public String toString(@Nullable BatchArtifactRefBean ref, ConvertContext context) {
        return ref == null ? "" : ref.getName();
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<BatchArtifactRefBean> value, PsiElement element, ConvertContext context) {
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/model/converters/BatchArtifactRefConverter", "createReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    public Collection<? extends BatchArtifactRefBean> getVariants(ConvertContext context) {
        Module module = context.getModule();
        if (module != null) {
            Set<BatchArtifactRefBean> set = BatchArtifactRefConverter.getSmartVariants(module, context);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/model/converters/BatchArtifactRefConverter", "getVariants"));
            }
            return set;
        }
        Set set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/model/converters/BatchArtifactRefConverter", "getVariants"));
        }
        return set;
    }

    @NotNull
    private static Set<BatchArtifactRefBean> getSmartVariants(@NotNull Module module, ConvertContext context) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/batch/model/converters/BatchArtifactRefConverter", "getSmartVariants"));
        }
        List<PsiClass> requiredClasses = RequiredArtifactTypeInspection.getRequiredArtifactTypeClasses(context.getInvocationElement());
        Set<BatchArtifactRefBean> refs = BatchCommonUtils.getBatchArtifactRefs(module);
        Set<BatchArtifactRefBean> set = requiredClasses.size() == 0 ? refs : BatchArtifactRefConverter.filterArtifactsByType(refs, requiredClasses, module.getProject());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/model/converters/BatchArtifactRefConverter", "getSmartVariants"));
        }
        return set;
    }

    @NotNull
    private static Set<BatchArtifactRefBean> filterArtifactsByType(@NotNull Set<BatchArtifactRefBean> refs, @NotNull List<PsiClass> classes, @NotNull Project project) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/batch/model/converters/BatchArtifactRefConverter", "filterArtifactsByType"));
        }
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/batch/model/converters/BatchArtifactRefConverter", "filterArtifactsByType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/batch/model/converters/BatchArtifactRefConverter", "filterArtifactsByType"));
        }
        HashSet filtered = new HashSet();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        for (BatchArtifactRefBean ref : refs) {
            for (PsiClass requiredClass : classes) {
                PsiType type = ref.getType();
                if (type == null || !factory.createType(requiredClass).isAssignableFrom(type)) continue;
                filtered.add(ref);
            }
        }
        HashSet hashSet = filtered;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/model/converters/BatchArtifactRefConverter", "filterArtifactsByType"));
        }
        return hashSet;
    }

    @Nullable
    public LookupElement createLookupElement(BatchArtifactRefBean bean) {
        String name = bean.getName();
        PsiType type = bean.getType();
        if (name != null && type != null) {
            return LookupElementBuilder.create((String)name).withTypeText(type.getPresentableText());
        }
        return null;
    }

    @Nullable
    public PsiElement getPsiElement(@Nullable BatchArtifactRefBean resolvedValue) {
        return resolvedValue == null ? null : resolvedValue.getPsiElement();
    }
}

