/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.java.CucumberJavaBundle;
import org.jetbrains.plugins.cucumber.java.run.CucumberJavaRunConfiguration;

public class CucumberJavaApplicationConfigurable
extends SettingsEditor<CucumberJavaRunConfiguration>
implements PanelWithAnchor {
    private final Project myProject;
    private JComponent myAnchor;
    private final ConfigurationModuleSelector myModuleSelector;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myMainClass;
    private JPanel myWholePanel;
    private LabeledComponent<ModulesComboBox> myModule;
    private LabeledComponent<RawCommandLineEditor> myGlue;
    private LabeledComponent<TextFieldWithBrowseButton> myFeatureOrFolder;
    private CommonJavaParametersPanel myCommonProgramParameters;
    private Module myModuleContext;

    public CucumberJavaApplicationConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myModuleSelector = new ConfigurationModuleSelector(project, (ModulesComboBox)this.myModule.getComponent());
        ClassBrowser.createApplicationClassBrowser((Project)project, (ConfigurationModuleSelector)this.myModuleSelector).setField((ComponentWithBrowseButton)this.myMainClass.getComponent());
        this.myModuleContext = this.myModuleSelector.getModule();
        ActionListener fileToRunActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
                fileChooserDescriptor.setTitle(CucumberJavaBundle.message("run.configuration.form.choose.file.or.folder.title", new Object[0]));
                fileChooserDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)CucumberJavaApplicationConfigurable.this.myModuleContext);
                Project project = CucumberJavaApplicationConfigurable.this.myProject;
                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Project)project, null);
                if (file != null) {
                    CucumberJavaApplicationConfigurable.this.setFeatureOrFolder(file.getPresentableUrl());
                }
            }
        };
        ((TextFieldWithBrowseButton)this.myFeatureOrFolder.getComponent()).getButton().addActionListener(fileToRunActionListener);
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myMainClass, this.myGlue, this.myFeatureOrFolder, this.myModule, this.myCommonProgramParameters});
        ((RawCommandLineEditor)this.myGlue.getComponent()).setDialogCaption(CucumberJavaBundle.message("run.configuration.form.glue.title", new Object[0]));
    }

    public void setFeatureOrFolder(String path) {
        ((TextFieldWithBrowseButton)this.myFeatureOrFolder.getComponent()).setText(path);
    }

    private void createUIComponents() {
        this.myMainClass = new LabeledComponent();
        this.myMainClass.setComponent((JComponent)new EditorTextFieldWithBrowseButton(this.myProject, true, new JavaCodeFragment.VisibilityChecker(){

            public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
                PsiClass aClass;
                if (declaration instanceof PsiClass && ConfigurationUtil.MAIN_CLASS.value((Object)(aClass = (PsiClass)declaration)) && PsiMethodUtil.findMainMethod((PsiClass)aClass) != null) {
                    return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
                }
                return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
            }
        }));
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myMainClass.setAnchor(anchor);
        this.myGlue.setAnchor(anchor);
        this.myFeatureOrFolder.setAnchor(anchor);
        this.myModule.setAnchor(anchor);
        this.myCommonProgramParameters.setAnchor(anchor);
    }

    protected void resetEditorFrom(CucumberJavaRunConfiguration configuration) {
        this.myModuleSelector.reset((ModuleBasedConfiguration)configuration);
        this.myCommonProgramParameters.reset((CommonJavaRunConfigurationParameters)configuration);
        ((EditorTextFieldWithBrowseButton)this.myMainClass.getComponent()).setText(configuration.MAIN_CLASS_NAME);
        ((RawCommandLineEditor)this.myGlue.getComponent()).setText(configuration.getGlue());
        ((TextFieldWithBrowseButton)this.myFeatureOrFolder.getComponent()).setText(configuration.getFilePath());
    }

    protected void applyEditorTo(CucumberJavaRunConfiguration configuration) throws ConfigurationException {
        this.myCommonProgramParameters.applyTo((CommonJavaRunConfigurationParameters)configuration);
        this.myModuleSelector.applyTo((ModuleBasedConfiguration)configuration);
        configuration.MAIN_CLASS_NAME = ((EditorTextFieldWithBrowseButton)this.myMainClass.getComponent()).getText();
        configuration.setGlue(((RawCommandLineEditor)this.myGlue.getComponent()).getText());
        configuration.setFilePath(((TextFieldWithBrowseButton)this.myFeatureOrFolder.getComponent()).getText());
        Module selectedModule = (Module)((ModulesComboBox)this.myModule.getComponent()).getSelectedItem();
        configuration.setModule(selectedModule);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaApplicationConfigurable", "createEditor"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        CommonJavaParametersPanel commonJavaParametersPanel;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        JPanel jPanel;
        this.createUIComponents();
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        LabeledComponent<EditorTextFieldWithBrowseButton> labeledComponent4 = this.myMainClass;
        labeledComponent4.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.main.class.label"));
        labeledComponent4.setLabelLocation("West");
        jPanel.add((Component)labeledComponent4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, new Dimension(-1, 20), null));
        this.myGlue = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setText(ResourceBundle.getBundle("org/jetbrains/plugins/cucumber/java/CucumberJavaBundle").getString("run.configuration.form.glue"));
        labeledComponent3.setComponentClass("com.intellij.ui.RawCommandLineEditor");
        labeledComponent3.setLabelLocation("West");
        jPanel.add((Component)labeledComponent3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myFeatureOrFolder = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setText(ResourceBundle.getBundle("org/jetbrains/plugins/cucumber/java/CucumberJavaBundle").getString("run.configuration.form.feature.or.folder.path"));
        labeledComponent2.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent2.setLabelLocation("West");
        jPanel.add((Component)labeledComponent2, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCommonProgramParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel.add((Component)commonJavaParametersPanel, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myModule = labeledComponent = new LabeledComponent();
        labeledComponent.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.use.classpath.and.jdk.of.module.label"));
        labeledComponent.setComponentClass("com.intellij.application.options.ModulesComboBox");
        labeledComponent.setLabelLocation("West");
        jPanel.add((Component)labeledComponent, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

