/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ExecutionResult;
import com.intellij.javascript.debugger.impl.DebuggableFileFinder;
import com.intellij.javascript.debugger.settings.JavaScriptDebuggerSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.PairFunction;
import com.intellij.util.SingleAlarm;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.debugger.wip.ChromeDebugProcess;
import com.jetbrains.debugger.wip.ToggleCaptureAsyncStackTracesAction;
import com.jetbrains.debugger.wip.WipConsoleAPICalled;
import com.jetbrains.debugger.wip.WipExceptionThrown;
import com.jetbrains.debugger.wip.WipLogEntry;
import com.jetbrains.javascript.debugger.ConsoleMessage;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptSuspendContext;
import com.jetbrains.javascript.debugger.V8ValueMarkerProvider;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManagerBase;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.wip.JSExecutionStackSuspendContext;
import org.jetbrains.wip.SerializableValue;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipNetworkManager;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipSuspendContextManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.log.EntryAddedEventData;
import org.jetbrains.wip.protocol.log.LogEntryValue;
import org.jetbrains.wip.protocol.runtime.ConsoleAPICalledEventData;
import org.jetbrains.wip.protocol.runtime.ExceptionDetailsValue;
import org.jetbrains.wip.protocol.runtime.ExceptionThrownEventData;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001:\u0001)B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ \u0010\u0018\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u001eH\u0016J&\u0010'\u001a\u00020\u001e2\u001e\u0010\u000b\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\fJ\b\u0010(\u001a\u00020\u001eH\u0002R&\u0010\u000b\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006*"}, d2={"Lcom/jetbrains/debugger/wip/ChromeDebugProcess;", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "finder", "Lcom/intellij/javascript/debugger/impl/DebuggableFileFinder;", "connection", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/javascript/debugger/impl/DebuggableFileFinder;Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/execution/ExecutionResult;)V", "breakpointLanguageHint", "Lcom/intellij/util/PairFunction;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lorg/jetbrains/debugger/Location;", "", "suspendContextBeforeResume", "Lcom/jetbrains/javascript/debugger/JavaScriptSuspendContext;", "valueMarkerProvider", "Lcom/jetbrains/javascript/debugger/V8ValueMarkerProvider;", "getValueMarkerProvider", "()Lcom/jetbrains/javascript/debugger/V8ValueMarkerProvider;", "valueMarkerProvider$delegate", "Lkotlin/Lazy;", "getBreakpointLanguageHint", "breakpoint", "location", "getCurrentLocationUrl", "Lcom/intellij/util/Url;", "registerAdditionalActions", "", "leftToolbar", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "topToolbar", "settings", "resume", "vm", "Lorg/jetbrains/debugger/Vm;", "sessionInitialized", "setBreakpointLanguageHint", "switchToNextThreadIfExists", "ConsoleMessageManager", "ChromeConnector"})
public class ChromeDebugProcess
extends JavaScriptDebugProcess<VmConnection<?>> {
    private PairFunction<XLineBreakpoint<?>, Location, String> breakpointLanguageHint;
    private JavaScriptSuspendContext suspendContextBeforeResume;
    @NotNull
    private final Lazy valueMarkerProvider$delegate;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    @Nullable
    public String getBreakpointLanguageHint(@Nullable XLineBreakpoint<?> breakpoint, @NotNull Location location) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        PairFunction<XLineBreakpoint<?>, Location, String> pairFunction = this.breakpointLanguageHint;
        return pairFunction != null ? (String)pairFunction.fun(breakpoint, (Object)location) : null;
    }

    public final void setBreakpointLanguageHint(@Nullable PairFunction<XLineBreakpoint<?>, Location, String> breakpointLanguageHint) {
        this.breakpointLanguageHint = breakpointLanguageHint;
    }

    @Nullable
    public Url getCurrentLocationUrl() {
        WipVm wipVm = (WipVm)this.getActiveOrMainVm();
        return wipVm != null ? wipVm.getCurrentUrl() : null;
    }

    public void sessionInitialized() {
        if (JavaScriptDebuggerSettings.getInstance().isCaptureAsyncStackTraces()) {
            AppUIUtil.invokeOnEdt((Runnable)new Runnable(this){
                final /* synthetic */ ChromeDebugProcess this$0;

                public final void run() {
                    block0: {
                        Vm vm = this.this$0.getActiveOrMainVm();
                        if (vm == null) break block0;
                        vm.setCaptureAsyncStackTraces(true);
                    }
                }
                {
                    this.this$0 = chromeDebugProcess;
                }
            });
        }
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        Intrinsics.checkParameterIsNotNull((Object)leftToolbar, (String)"leftToolbar");
        Intrinsics.checkParameterIsNotNull((Object)topToolbar, (String)"topToolbar");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        super.registerAdditionalActions(leftToolbar, topToolbar, settings);
        topToolbar.add((AnAction)new ToggleCaptureAsyncStackTracesAction());
    }

    @NotNull
    public V8ValueMarkerProvider getValueMarkerProvider() {
        Lazy lazy = this.valueMarkerProvider$delegate;
        ChromeDebugProcess chromeDebugProcess = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (V8ValueMarkerProvider)lazy.getValue();
    }

    public void resume(@NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Promise continueVm = this.continueVm(vm, StepAction.CONTINUE);
        if (this.getLastStep() == null && continueVm != null) {
            continueVm.done((Consumer)new Consumer<Object>(this){
                final /* synthetic */ ChromeDebugProcess this$0;

                public final void consume(Object it) {
                    ChromeDebugProcess.access$switchToNextThreadIfExists(this.this$0);
                }
                {
                    this.this$0 = chromeDebugProcess;
                }
            });
        }
    }

    private final void switchToNextThreadIfExists() {
        XDebugSession session2 = this.getSession();
        JavaScriptSuspendContext suspendContext = this.suspendContextBeforeResume;
        if (session2.getSuspendContext() != null || suspendContext == null) {
            return;
        }
        Vm vm = this.getActiveOrMainVm();
        Object object = vm != null ? vm.getSuspendContextManager() : null;
        if (!(object instanceof WipSuspendContextManager)) {
            object = null;
        }
        WipSuspendContextManager wipSuspendContextManager = (WipSuspendContextManager)((Object)object);
        if (wipSuspendContextManager == null) {
            return;
        }
        WipSuspendContextManager suspendContextManager = wipSuspendContextManager;
        SuspendContext context = suspendContextManager.getContext();
        for (JSExecutionStackSuspendContext<WipSuspendContext, WipCallFrame> threadContext : suspendContextManager.getThreadSuspendContexts().values()) {
            if (!(Intrinsics.areEqual((Object)((Object)threadContext.getSuspendContext()), (Object)context) ^ true)) continue;
            Script script = threadContext.getScript();
            if (script == null) break;
            Script script2 = script;
            Script it = script2;
            suspendContextManager.getContextRef().set(threadContext.getSuspendContext());
            session2.positionReached((XSuspendContext)suspendContext);
            break;
        }
    }

    public ChromeDebugProcess(final @NotNull XDebugSession session2, @NotNull DebuggableFileFinder finder, @NotNull VmConnection<?> connection, @Nullable ExecutionResult executionResult) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)finder, (String)"finder");
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        super(session2, finder, connection, executionResult);
        connection.executeOnStart(new Runnable(){

            @Override
            public final void run() {
                Vm vm = this.getMainVm();
                if (vm == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipVm");
                }
                WipVm vm2 = (WipVm)vm;
                ConsoleMessageManager messageManager = new ConsoleMessageManager(vm2.getNetworkManager(), (Disposable)this);
                EventType[] elements$iv = new EventType[]{ConsoleAPICalledEventData.TYPE, EntryAddedEventData.TYPE, ExceptionThrownEventData.TYPE};
                Object[] $receiver$iv = elements$iv;
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    EventType it = (EventType)element$iv;
                    vm2.getCommandProcessor().getEventMap().add(it, (Function1)new Function1<Object, Unit>(vm2, messageManager){
                        final /* synthetic */ WipVm $vm$inlined;
                        final /* synthetic */ ConsoleMessageManager $messageManager$inlined;

                        public final void invoke(Object it) {
                            this.$messageManager$inlined.add(it);
                        }
                        {
                            this.$vm$inlined = wipVm;
                            this.$messageManager$inlined = consoleMessageManager;
                            super(1);
                        }
                    });
                }
            }
        });
        connection.addDebugListener(new DebugEventListener(){

            public void navigated(@NotNull String newUrl) {
                Intrinsics.checkParameterIsNotNull((Object)newUrl, (String)"newUrl");
                this.getConsolePrinter().clear();
            }
        });
        session2.addSessionListener(new XDebugSessionListener(){

            public void stackFrameChanged() {
                block4: {
                    XDebugProcess xDebugProcess = session2.getDebugProcess();
                    if (!(xDebugProcess instanceof DebugProcessImpl)) {
                        xDebugProcess = null;
                    }
                    DebugProcessImpl debugProcessImpl = (DebugProcessImpl)xDebugProcess;
                    if (debugProcessImpl == null) break block4;
                    DebugProcessImpl debugProcessImpl2 = debugProcessImpl;
                    DebugProcessImpl it = debugProcessImpl2;
                    Vm vm = it.getActiveOrMainVm();
                    Object object = vm != null ? vm.getSuspendContextManager() : null;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipSuspendContextManager");
                    }
                    WipSuspendContextManager suspendContextManager = (WipSuspendContextManager)((Object)object);
                    XStackFrame currentStackFrame = session2.getCurrentStackFrame();
                    if (suspendContextManager instanceof SuspendContextManagerBase && currentStackFrame instanceof CallFrameView) {
                        CallFrame currentCallFrame = ((CallFrameView)currentStackFrame).getCallFrame();
                        for (JSExecutionStackSuspendContext<WipSuspendContext, WipCallFrame> stack : suspendContextManager.getThreadSuspendContexts().values()) {
                            WipSuspendContext suspendContext = stack.getSuspendContext();
                            if (!Intrinsics.areEqual((Object)currentCallFrame, (Object)suspendContext.getTopFrame())) continue;
                            suspendContextManager.updateContext((SuspendContext)stack.getSuspendContext());
                            session2.rebuildViews();
                            break;
                        }
                    }
                }
            }

            public void beforeSessionResume() {
                XSuspendContext suspendContext = session2.getSuspendContext();
                if (suspendContext instanceof JavaScriptSuspendContext) {
                    suspendContextBeforeResume = (JavaScriptSuspendContext)suspendContext;
                }
            }
        });
        this.valueMarkerProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<valueMarkerProvider.1>(this){
            final /* synthetic */ ChromeDebugProcess this$0;

            @NotNull
            public final valueMarkerProvider.1 invoke() {
                return new V8ValueMarkerProvider(this, this.this$0){
                    final /* synthetic */ valueMarkerProvider.2 this$0;

                    @Nullable
                    public String getRefId(@Nullable Value value) {
                        return value instanceof SerializableValue ? ((SerializableValue)value).getRefId() : (String)null;
                    }
                    {
                        this.this$0 = $outer;
                        super($super_call_param$1);
                    }
                };
            }
            {
                this.this$0 = chromeDebugProcess;
                super(0);
            }
        }));
    }

    public /* synthetic */ ChromeDebugProcess(XDebugSession xDebugSession, DebuggableFileFinder debuggableFileFinder, VmConnection vmConnection, ExecutionResult executionResult, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            executionResult = null;
        }
        this(xDebugSession, debuggableFileFinder, vmConnection, executionResult);
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ChromeDebugProcess.class), "valueMarkerProvider", "getValueMarkerProvider()Lcom/jetbrains/javascript/debugger/V8ValueMarkerProvider;"))};
    }

    public static final /* synthetic */ void access$switchToNextThreadIfExists(ChromeDebugProcess $this) {
        $this.switchToNextThreadIfExists();
    }

    @Nullable
    public static final /* synthetic */ JavaScriptSuspendContext access$getSuspendContextBeforeResume$p(ChromeDebugProcess $this) {
        return $this.suspendContextBeforeResume;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0001H\u0007J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0001H\u0002JK\u0010\u001a\u001a\u00020\u001b\"\u0004\b\u0000\u0010\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u0002H\u001c\u0018\u00010\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u0002H\u001c\u0018\u00010\u001e2\u001a\b\u0004\u0010 \u001a\u0014\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u00020\u001b0!H\u0082\bJ\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0001H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/jetbrains/debugger/wip/ChromeDebugProcess$ConsoleMessageManager;", "", "networkManager", "Lorg/jetbrains/wip/WipNetworkManager;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/jetbrains/debugger/wip/ChromeDebugProcess;Lorg/jetbrains/wip/WipNetworkManager;Lcom/intellij/openapi/Disposable;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "getAlarm", "()Lcom/intellij/util/SingleAlarm;", "lastMessage", "getLastMessage", "()Ljava/lang/Object;", "setLastMessage", "(Ljava/lang/Object;)V", "repeatCount", "", "getRepeatCount", "()I", "setRepeatCount", "(I)V", "add", "", "message", "doAdd", "listsAreEqual", "", "T", "a1", "", "a2", "comparator", "Lkotlin/Function2;", "messagesEquals", "m1", "m2", "ChromeConnector"})
    private final class ConsoleMessageManager {
        @NotNull
        private final SingleAlarm alarm;
        @Nullable
        private Object lastMessage;
        private int repeatCount;
        private final WipNetworkManager networkManager;

        @NotNull
        public final SingleAlarm getAlarm() {
            return this.alarm;
        }

        @Nullable
        public final Object getLastMessage() {
            return this.lastMessage;
        }

        public final void setLastMessage(@Nullable Object object) {
            this.lastMessage = object;
        }

        public final int getRepeatCount() {
            return this.repeatCount;
        }

        public final void setRepeatCount(int n) {
            this.repeatCount = n;
        }

        public final synchronized void add(@NotNull Object message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Object it = this.lastMessage;
            if (it != null) {
                if (this.messagesEquals(it, message)) {
                    int n = this.repeatCount;
                    this.repeatCount = n + 1;
                    return;
                }
                this.doAdd(it);
            }
            this.lastMessage = message;
            this.repeatCount = 0;
            this.alarm.cancelAndRequest();
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean messagesEquals(Object m1, Object m2) {
            if (m1 instanceof ConsoleAPICalledEventData) {
                void a2$iv;
                void a1$iv;
                if (!(m2 instanceof ConsoleAPICalledEventData)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)((Object)((ConsoleAPICalledEventData)m1).type()), (Object)((Object)((ConsoleAPICalledEventData)m2).type()))) return false;
                if (((ConsoleAPICalledEventData)m1).getExecutionContextId() != ((ConsoleAPICalledEventData)m2).getExecutionContextId()) return false;
                ConsoleMessageManager consoleMessageManager = this;
                List<RemoteObjectValue> list = ((ConsoleAPICalledEventData)m1).args();
                List<RemoteObjectValue> list2 = ((ConsoleAPICalledEventData)m2).args();
                if (a1$iv != null && a2$iv != null) {
                    if (a1$iv.size() != a2$iv.size()) {
                        return false;
                    }
                    int n = 0;
                    int n2 = ((Collection)a1$iv).size() - 1;
                    if (n > n2) return true;
                    while (true) {
                        void e2;
                        void i$iv;
                        RemoteObjectValue remoteObjectValue = (RemoteObjectValue)a2$iv.get((int)i$iv);
                        RemoteObjectValue e1 = (RemoteObjectValue)a1$iv.get((int)i$iv);
                        if (!Intrinsics.areEqual((Object)e1.value(), (Object)e2.value())) {
                            return false;
                        }
                        if (i$iv == n2) return true;
                        ++i$iv;
                    }
                }
                boolean bl = Intrinsics.areEqual((Object)a1$iv, (Object)a2$iv);
                if (!bl) return false;
                return true;
            }
            if (m1 instanceof EntryAddedEventData) {
                if (!(m2 instanceof EntryAddedEventData)) {
                    return false;
                }
                LogEntryValue entry1 = ((EntryAddedEventData)m1).entry();
                LogEntryValue entry2 = ((EntryAddedEventData)m2).entry();
                if (entry1.getLineNumber() != entry2.getLineNumber()) return false;
                if (!Intrinsics.areEqual((Object)((Object)entry1.source()), (Object)((Object)entry2.source()))) return false;
                if (!Intrinsics.areEqual((Object)((Object)entry1.level()), (Object)((Object)entry2.level()))) return false;
                if (!Intrinsics.areEqual((Object)entry1.getUrl(), (Object)entry2.getUrl())) return false;
                if (!Intrinsics.areEqual((Object)entry1.text(), (Object)entry2.text())) return false;
                return true;
            }
            if (!(m1 instanceof ExceptionThrownEventData)) return false;
            if (!(m2 instanceof ExceptionThrownEventData)) {
                return false;
            }
            ExceptionDetailsValue d1 = ((ExceptionThrownEventData)m1).exceptionDetails();
            ExceptionDetailsValue d2 = ((ExceptionThrownEventData)m2).exceptionDetails();
            if (!Intrinsics.areEqual((Object)d1.getUrl(), (Object)d2.getUrl())) return false;
            if (d1.getLineNumber() != d2.getLineNumber()) return false;
            if (d1.getColumnNumber() != d2.getColumnNumber()) return false;
            if (!Intrinsics.areEqual((Object)d1.text(), (Object)d2.text())) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final <T> boolean listsAreEqual(List<? extends T> a1, List<? extends T> a2, Function2<? super T, ? super T, Boolean> comparator) {
            if (a1 == null || a2 == null) {
                return Intrinsics.areEqual(a1, a2);
            }
            if (a1.size() != a2.size()) {
                return false;
            }
            int n = 0;
            int n2 = ((Collection)a1).size() - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    if (!((Boolean)comparator.invoke(a1.get((int)i), a2.get((int)i))).booleanValue()) {
                        return false;
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            return true;
        }

        private final void doAdd(Object message) {
            ConsoleMessage consoleMessage;
            Object object = message;
            if (object instanceof ConsoleAPICalledEventData) {
                consoleMessage = new WipConsoleAPICalled((ConsoleAPICalledEventData)message);
            } else if (object instanceof EntryAddedEventData) {
                consoleMessage = new WipLogEntry(((EntryAddedEventData)message).entry(), this.networkManager.getRequest(((EntryAddedEventData)message).entry().getNetworkRequestId()));
            } else if (object instanceof ExceptionThrownEventData) {
                consoleMessage = new WipExceptionThrown((ExceptionThrownEventData)message);
            } else {
                throw (Throwable)new IllegalArgumentException(message.getClass().getName());
            }
            ConsoleMessage consoleMessage2 = consoleMessage;
            ChromeDebugProcess.this.getConsolePrinter().add(consoleMessage2, this.repeatCount);
        }

        public ConsoleMessageManager(@NotNull WipNetworkManager networkManager, Disposable disposable) {
            Intrinsics.checkParameterIsNotNull((Object)networkManager, (String)"networkManager");
            Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
            this.networkManager = networkManager;
            this.alarm = new SingleAlarm(new Runnable(this){
                final /* synthetic */ ConsoleMessageManager this$0;

                public final void run() {
                    block0: {
                        Object object = this.this$0.getLastMessage();
                        if (object == null) break block0;
                        Object object2 = object;
                        Object it = object2;
                        this.this$0.setLastMessage(null);
                        ConsoleMessageManager.access$doAdd(this.this$0, it);
                        this.this$0.setRepeatCount(0);
                    }
                }
                {
                    this.this$0 = consoleMessageManager;
                }
            }, 100, Alarm.ThreadToUse.POOLED_THREAD, disposable);
        }

        public static final /* synthetic */ void access$doAdd(ConsoleMessageManager $this, @NotNull Object message) {
            $this.doAdd(message);
        }
    }
}

