/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.reactnative.PackagerState;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0002J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011R,\u0010\u0003\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativePackager;", "Lcom/intellij/openapi/Disposable;", "()V", "packagers", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/Pair;", "Lcom/intellij/execution/process/OSProcessHandler;", "Lorg/jetbrains/concurrency/AsyncPromise;", "Ljava/lang/Void;", "dispose", "", "getStartedPackager", "Lcom/jetbrains/plugins/reactnative/PackagerState;", "workingDir", "startPackager", "configuration", "Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "ChromeConnector"})
public final class ReactNativePackager
implements Disposable {
    private final Map<VirtualFile, Pair<OSProcessHandler, AsyncPromise<Void>>> packagers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final PackagerState startPackager(@NotNull ReactNativeRunConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)configuration), (String)"configuration");
        VirtualFile workingDir = LocalFileSystem.getInstance().findFileByPath(configuration.getEffectiveWorkingDirectory());
        PackagerState packagerState = this.getStartedPackager(workingDir);
        if (packagerState != null) {
            PackagerState packagerState2 = packagerState;
            PackagerState it2 = packagerState2;
            return it2;
        }
        Map<VirtualFile, Pair<OSProcessHandler, AsyncPromise<Void>>> map = this.packagers;
        synchronized (map) {
            block7: {
                PackagerState it;
                PackagerState packagerState3 = this.getStartedPackager(workingDir);
                if (packagerState3 == null) break block7;
                PackagerState it2 = packagerState3;
                PackagerState packagerState4 = it = it2;
                return packagerState4;
            }
            AsyncPromise promise2 = new AsyncPromise();
            GeneralCommandLine commandLine = new GeneralCommandLine().withEnvironment("REACT_DEBUGGER", ":");
            commandLine.setExePath(configuration.getNodePath().resolveAsLocal(configuration.getProject()).getInterpreterSystemDependentPath());
            Object object = configuration.getReactNativePackage();
            if (object == null || (object = object.getSystemDependentPath()) == null) {
                throw (Throwable)new ConfigurationException("invalid react-native path");
            }
            commandLine.addParameter((String)object);
            commandLine.addParameter("start");
            commandLine.withWorkDirectory(configuration.getEffectiveWorkingDirectory());
            OSProcessHandler processHandler = new OSProcessHandler(commandLine);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(promise2, this, workingDir, configuration){
                final /* synthetic */ AsyncPromise $promise;
                final /* synthetic */ ReactNativePackager this$0;
                final /* synthetic */ VirtualFile $workingDir$inlined;
                final /* synthetic */ ReactNativeRunConfiguration $configuration$inlined;

                public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                    Object object;
                    if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT) && ((object = event) != null && (object = object.getText()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"React packager ready.", (boolean)false, (int)2, null) : false)) {
                        this.$promise.setResult(null);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void processTerminated(ProcessEvent event) {
                    Object object;
                    if (this.$workingDir$inlined != null) {
                        Map map = ReactNativePackager.access$getPackagers$p(this.this$0);
                        synchronized (map) {
                            Pair pair = (Pair)ReactNativePackager.access$getPackagers$p(this.this$0).remove(this.$workingDir$inlined);
                        }
                    }
                    if ((object = event) == null || (object = object.getText()) == null) {
                        object = "";
                    }
                    this.$promise.setError((String)object);
                }
                {
                    this.$promise = $captured_local_variable$1;
                    this.this$0 = reactNativePackager;
                    this.$workingDir$inlined = virtualFile;
                    this.$configuration$inlined = reactNativeRunConfiguration;
                }
            });
            processHandler.startNotify();
            if (workingDir != null) {
                Map<VirtualFile, Pair<OSProcessHandler, AsyncPromise<Void>>> map2 = this.packagers;
                VirtualFile virtualFile = workingDir;
                Pair pair = new Pair((Object)processHandler, (Object)promise2);
                map2.put(virtualFile, (Pair<OSProcessHandler, AsyncPromise<Void>>)pair);
            }
            PackagerState packagerState5 = new PackagerState(processHandler, false, (Promise<Void>)((Promise)promise2));
            return packagerState5;
        }
    }

    private final PackagerState getStartedPackager(VirtualFile workingDir) {
        if (workingDir == null) {
            return null;
        }
        Pair<OSProcessHandler, AsyncPromise<Void>> packager = this.packagers.get(workingDir);
        return packager != null && !((OSProcessHandler)packager.getFirst()).isProcessTerminated() ? new PackagerState((OSProcessHandler)packager.getFirst(), true, (Promise<Void>)((Promise)packager.getSecond())) : (PackagerState)null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<VirtualFile, Pair<OSProcessHandler, AsyncPromise<Void>>> map = this.packagers;
        synchronized (map) {
            for (Pair<OSProcessHandler, AsyncPromise<Void>> unit2 : this.packagers.values()) {
                OSProcessHandler process2 = (OSProcessHandler)unit2.component1();
                if (process2.isProcessTerminated()) continue;
                process2.destroyProcess();
            }
            this.packagers.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public ReactNativePackager() {
        HashMap hashMap = ContainerUtil.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"ContainerUtil.newHashMap()");
        this.packagers = hashMap;
    }

    @NotNull
    public static final /* synthetic */ Map access$getPackagers$p(ReactNativePackager $this) {
        return $this.packagers;
    }
}

