/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.AsyncGenericProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.Function;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.plugins.reactnative.PackagerState;
import com.jetbrains.plugins.reactnative.ReactNativePackagerKt;
import com.jetbrains.plugins.reactnative.ReactNativeProcessState;
import com.jetbrains.plugins.reactnative.ReactNativeProgramRunner;
import com.jetbrains.plugins.reactnative.ReactNativeProgramRunner$prepare$1$1$onTextAvailable$;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import icons.ChromeConnectorIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.InetSocketAddress;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeProgramRunner;", "Lcom/intellij/execution/runners/AsyncGenericProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "getRunnerId", "prepare", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/RunProfileStarter;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "showHelperProcessRunContent", "", "header", "runHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "ChromeConnector"})
public final class ReactNativeProgramRunner
extends AsyncGenericProgramRunner<RunnerSettings> {
    @NotNull
    public String getRunnerId() {
        return "reactNativeRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)executorId, (String)"executorId");
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        return profile instanceof ReactNativeRunConfiguration && (Intrinsics.areEqual((Object)executorId, (Object)DefaultRunExecutor.EXECUTOR_ID) || Intrinsics.areEqual((Object)executorId, (Object)DefaultDebugExecutor.EXECUTOR_ID));
    }

    @NotNull
    protected Promise<RunProfileStarter> prepare(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        FileDocumentManager.getInstance().saveAllDocuments();
        RunProfile runProfile = environment.getRunProfile();
        if (runProfile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration");
        }
        ReactNativeRunConfiguration configuration = (ReactNativeRunConfiguration)runProfile;
        InetSocketAddress socketAddress = configuration.computeDebugAddress(state);
        PackagerState startReactNativePackager = ReactNativePackagerKt.startReactNativePackager(configuration);
        OSProcessHandler starterProcess = startReactNativePackager.getProcess();
        if (!startReactNativePackager.getAlreadyStarted()) {
            this.showHelperProcessRunContent("react-native start", starterProcess, environment);
        }
        Promise promise2 = startReactNativePackager.getReady().thenAsync((Function)new Function<Void, Promise<RunProfileStarter>>(this, starterProcess, socketAddress, configuration, environment){
            final /* synthetic */ ReactNativeProgramRunner this$0;
            final /* synthetic */ OSProcessHandler $starterProcess;
            final /* synthetic */ InetSocketAddress $socketAddress;
            final /* synthetic */ ReactNativeRunConfiguration $configuration;
            final /* synthetic */ ExecutionEnvironment $environment;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final AsyncPromise<RunProfileStarter> fun(Void it) {
                void var2_2;
                AsyncPromise packagerCalledDebug = new AsyncPromise();
                this.$starterProcess.addProcessListener((ProcessListener)new ProcessAdapter(this, packagerCalledDebug){
                    final /* synthetic */ prepare.1 this$0;
                    final /* synthetic */ AsyncPromise $packagerCalledDebug;

                    public void onTextAvailable(@Nullable ProcessEvent event, @Nullable Key<?> outputType) {
                        Object object;
                        if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT) && ((object = event) != null && (object = object.getText()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"Starting custom debugger by executing", (boolean)false, (int)2, null) : false)) {
                            this.this$0.$starterProcess.removeProcessListener((ProcessListener)this);
                            RunProfileStarter starter = new RunProfileStarter(this){
                                final /* synthetic */ prepare.1 this$0;

                                /*
                                 * WARNING - void declaration
                                 */
                                public RunContentDescriptor execute(RunProfileState state, ExecutionEnvironment env) {
                                    void environment;
                                    ExecutionEnvironment executionEnvironment = env;
                                    RunProfileState state2 = state;
                                    void var5_5 = environment;
                                    XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)environment.getProject());
                                    XDebugProcessStarter xDebugProcessStarter2 = new XDebugProcessStarter(state2, (ExecutionEnvironment)environment, this){
                                        final /* synthetic */ RunProfileState $state$inlined;
                                        final /* synthetic */ ExecutionEnvironment $environment$inlined;
                                        final /* synthetic */ prepare$1$1$onTextAvailable$$inlined$runProfileStarter$1 this$0;

                                        public XDebugProcess start(XDebugSession session2) {
                                            XDebugSession it = session2;
                                            RunProfileState runProfileState = this.$state$inlined;
                                            if (runProfileState == null) {
                                                throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.plugins.reactnative.ReactNativeProcessState");
                                            }
                                            ExecutionResult executionResult = ((ReactNativeProcessState)runProfileState).execute(this.this$0.this$0.this$0.$socketAddress.getPort());
                                            ReactNativeRunConfiguration reactNativeRunConfiguration = this.this$0.this$0.this$0.$configuration;
                                            InetSocketAddress inetSocketAddress = this.this$0.this$0.this$0.$socketAddress;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)inetSocketAddress, (String)"socketAddress");
                                            return reactNativeRunConfiguration.createDebugProcess(inetSocketAddress, it, executionResult, this.$environment$inlined);
                                        }
                                        {
                                            this.$state$inlined = runProfileState;
                                            this.$environment$inlined = executionEnvironment;
                                            this.this$0 = var3_3;
                                        }
                                    };
                                    XDebugSession xDebugSession = xDebuggerManager.startSession((ExecutionEnvironment)var5_5, xDebugProcessStarter2);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"XDebuggerManager.getInst\u2026gProcessStarter(starter))");
                                    return xDebugSession.getRunContentDescriptor();
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            };
                            this.$packagerCalledDebug.setResult((Object)starter);
                        }
                    }
                    {
                        this.this$0 = $outer;
                        this.$packagerCalledDebug = $captured_local_variable$1;
                    }
                });
                GeneralCommandLine runCommandLine = new GeneralCommandLine();
                runCommandLine.setExePath(this.$configuration.getNodePath().resolveAsLocal(this.$environment.getProject()).getInterpreterSystemDependentPath());
                Object object = this.$configuration.getReactNativePackage();
                if (object == null || (object = object.getSystemDependentPath()) == null) {
                    throw (Throwable)new ConfigurationException("invalid react-native path");
                }
                runCommandLine.addParameter((String)object);
                runCommandLine.addParameter(this.$configuration.getPlatform().getCommandLineArgument());
                runCommandLine.withWorkDirectory(this.$configuration.getEffectiveWorkingDirectory());
                ApplicationManager.getApplication().invokeLater(new Runnable(this, runCommandLine){
                    final /* synthetic */ prepare.1 this$0;
                    final /* synthetic */ GeneralCommandLine $runCommandLine;

                    public final void run() {
                        OSProcessHandler runHandler = new OSProcessHandler(this.$runCommandLine);
                        ReactNativeProgramRunner.access$showHelperProcessRunContent(this.this$0.this$0, "react-native " + this.this$0.$configuration.getPlatform().getCommandLineArgument(), runHandler, this.this$0.$environment);
                        runHandler.startNotify();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$runCommandLine = generalCommandLine;
                    }
                });
                return var2_2;
            }
            {
                this.this$0 = reactNativeProgramRunner;
                this.$starterProcess = oSProcessHandler;
                this.$socketAddress = inetSocketAddress;
                this.$configuration = reactNativeRunConfiguration;
                this.$environment = executionEnvironment;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"startReactNativePackager\u2026agerCalledDebug\n        }");
        return promise2;
    }

    private final void showHelperProcessRunContent(String header, OSProcessHandler runHandler, ExecutionEnvironment environment) {
        ConsoleViewImpl consoleView = new ConsoleViewImpl(environment.getProject(), true);
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)consoleView.getComponent(), "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent(consoleView.getComponent());
        panel.add((Component)toolbar.getComponent(), "West");
        RunContentDescriptor runDescriptor = new RunContentDescriptor((ExecutionConsole)consoleView, (ProcessHandler)runHandler, (JComponent)panel, header, ChromeConnectorIcons.ReactNative);
        AnAction[] anActionArray = consoleView.createConsoleActions();
        toolbarActions.addAll(Arrays.copyOf(anActionArray, anActionArray.length));
        toolbarActions.add((AnAction)new CloseAction(environment.getExecutor(), runDescriptor, environment.getProject()));
        consoleView.attachToProcess((ProcessHandler)runHandler);
        ExecutionManager.getInstance((Project)environment.getProject()).getContentManager().showRunContent(environment.getExecutor(), runDescriptor);
    }

    public static final /* synthetic */ void access$showHelperProcessRunContent(ReactNativeProgramRunner $this, @NotNull String header, @NotNull OSProcessHandler runHandler, @NotNull ExecutionEnvironment environment) {
        $this.showHelperProcessRunContent(header, runHandler, environment);
    }
}

