/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.application.ApplicationConfigurationProducer;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;

public class SpringBootApplicationRunConfigurationProducer
extends JavaRunConfigurationProducerBase<SpringBootApplicationRunConfiguration> {
    public SpringBootApplicationRunConfigurationProducer() {
        super((ConfigurationType)SpringBootApplicationConfigurationTypeBase.getInstance());
    }

    protected boolean setupConfigurationFromContext(SpringBootApplicationRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Module module = context.getModule();
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(module)) {
            return false;
        }
        PsiClass psiClass = ApplicationConfigurationType.getMainClass((PsiElement)((PsiElement)sourceElement.get()));
        if (psiClass == null || !SpringBootApplicationUtil.isSpringApplication((PsiClass)psiClass)) {
            return false;
        }
        sourceElement.set((Object)psiClass);
        configuration.setSpringBootMainClass(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass));
        configuration.setGeneratedName();
        this.setupConfigurationModule(context, configuration);
        return true;
    }

    public boolean isConfigurationFromContext(SpringBootApplicationRunConfiguration configuration, ConfigurationContext context) {
        Module configurationModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        if (!Comparing.equal((Object)context.getModule(), (Object)configurationModule)) {
            return false;
        }
        PsiClass contextPsiClass = ApplicationConfigurationType.getMainClass((PsiElement)context.getPsiLocation());
        if (contextPsiClass == null) {
            return false;
        }
        String configFqn = configuration.getSpringBootMainClass();
        return Comparing.strEqual((String)configFqn, (String)contextPsiClass.getQualifiedName());
    }

    public boolean shouldReplace(ConfigurationFromContext self, ConfigurationFromContext other) {
        return other.isProducedBy(ApplicationConfigurationProducer.class);
    }
}

