/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.drools.DroolsFileType;
import com.intellij.plugins.drools.DroolsLanguage;
import com.intellij.plugins.drools.lang.lexer.DroolsTokenTypeSets;
import com.intellij.plugins.drools.lang.psi.DroolsAttribute;
import com.intellij.plugins.drools.lang.psi.DroolsDeclareStatement;
import com.intellij.plugins.drools.lang.psi.DroolsFunctionStatement;
import com.intellij.plugins.drools.lang.psi.DroolsGlobalStatement;
import com.intellij.plugins.drools.lang.psi.DroolsImport;
import com.intellij.plugins.drools.lang.psi.DroolsPackageStatement;
import com.intellij.plugins.drools.lang.psi.DroolsQueryStatement;
import com.intellij.plugins.drools.lang.psi.DroolsRuleStatement;
import com.intellij.plugins.drools.lang.psi.util.DroolsElementsFactory;
import com.intellij.psi.FileResolveScopeProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DroolsFile
extends PsiFileBase
implements PsiImportHolder,
FileResolveScopeProvider {
    public DroolsFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/plugins/drools/lang/psi/DroolsFile", "<init>"));
        }
        super(viewProvider, (Language)DroolsLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        DroolsFileType droolsFileType = DroolsFileType.DROOLS_FILE_TYPE;
        if (droolsFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/DroolsFile", "getFileType"));
        }
        return droolsFileType;
    }

    public String toString() {
        return "Drools File";
    }

    public Icon getIcon(int flags) {
        return super.getIcon(flags);
    }

    @NotNull
    public DroolsDeclareStatement[] getDeclarations() {
        DroolsDeclareStatement[] droolsDeclareStatementArray = (DroolsDeclareStatement[])this.findChildrenByClass(DroolsDeclareStatement.class);
        if (droolsDeclareStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/DroolsFile", "getDeclarations"));
        }
        return droolsDeclareStatementArray;
    }

    @NotNull
    public DroolsRuleStatement[] getRules() {
        DroolsRuleStatement[] droolsRuleStatementArray = (DroolsRuleStatement[])this.findChildrenByClass(DroolsRuleStatement.class);
        if (droolsRuleStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/DroolsFile", "getRules"));
        }
        return droolsRuleStatementArray;
    }

    @NotNull
    public DroolsFunctionStatement[] getFunctions() {
        DroolsFunctionStatement[] droolsFunctionStatementArray = (DroolsFunctionStatement[])this.findChildrenByClass(DroolsFunctionStatement.class);
        if (droolsFunctionStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/DroolsFile", "getFunctions"));
        }
        return droolsFunctionStatementArray;
    }

    @NotNull
    public DroolsQueryStatement[] getQueries() {
        DroolsQueryStatement[] droolsQueryStatementArray = (DroolsQueryStatement[])this.findChildrenByClass(DroolsQueryStatement.class);
        if (droolsQueryStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/DroolsFile", "getQueries"));
        }
        return droolsQueryStatementArray;
    }

    public DroolsImport[] getImports() {
        return (DroolsImport[])this.findChildrenByClass(DroolsImport.class);
    }

    public DroolsGlobalStatement[] getGlobalVariables() {
        return (DroolsGlobalStatement[])this.findChildrenByClass(DroolsGlobalStatement.class);
    }

    @Nullable
    public DroolsPackageStatement getPackage() {
        return (DroolsPackageStatement)this.findChildByClass(DroolsPackageStatement.class);
    }

    @NotNull
    public DroolsAttribute[] getAttributes() {
        DroolsAttribute[] droolsAttributeArray = (DroolsAttribute[])this.findChildrenByClass(DroolsAttribute.class);
        if (droolsAttributeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/DroolsFile", "getAttributes"));
        }
        return droolsAttributeArray;
    }

    @Nullable
    public DroolsAttribute findAttributeByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/plugins/drools/lang/psi/DroolsFile", "findAttributeByName"));
        }
        for (DroolsAttribute attribute : this.getAttributes()) {
            if (!name.equals(attribute.getAttributeName())) continue;
            return attribute;
        }
        return null;
    }

    public boolean importClass(PsiClass aClass) {
        String qName = aClass.getQualifiedName();
        if (qName == null) {
            return false;
        }
        for (DroolsImport anImport : this.getImports()) {
            if (!qName.equals(anImport.getImportedClassName())) continue;
            return true;
        }
        try {
            DroolsImport importStatement = DroolsElementsFactory.createDroolsImport(qName, this.getProject());
            if (importStatement != null) {
                return this.addImport(importStatement) != null;
            }
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return false;
    }

    public DroolsImport addImport(@NotNull DroolsImport droolsImport) throws IncorrectOperationException {
        if (droolsImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsImport", "com/intellij/plugins/drools/lang/psi/DroolsFile", "addImport"));
        }
        PsiElement anchor = this.getAnchorToInsertImportAfter(droolsImport);
        FileASTNode node = this.getNode();
        PsiElement result = null;
        if (anchor == null) {
            PsiElement sibling;
            PsiElement psiElement = this.getFirstChild();
            if (psiElement != null && (sibling = (result = this.addBefore((PsiElement)droolsImport, psiElement)).getNextSibling()) != null) {
                node.addLeaf(DroolsTokenTypeSets.NEW_LINE, (CharSequence)StringUtil.repeat((String)"\n", (int)1), sibling.getNode());
            }
        } else {
            result = this.addAfter((PsiElement)droolsImport, anchor);
            node.addLeaf(DroolsTokenTypeSets.NEW_LINE, (CharSequence)StringUtil.repeat((String)"\n", (int)1), result.getNode());
        }
        return (DroolsImport)result;
    }

    @Nullable
    private PsiElement getAnchorToInsertImportAfter(@NotNull DroolsImport droolsImport) {
        if (droolsImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsImport", "com/intellij/plugins/drools/lang/psi/DroolsFile", "getAnchorToInsertImportAfter"));
        }
        DroolsImport[] importStatements = this.getImports();
        if (importStatements.length == 0) {
            DroolsPackageStatement aPackage = this.getPackage();
            if (aPackage != null) {
                return aPackage;
            }
        } else {
            return importStatements[importStatements.length - 1];
        }
        return null;
    }

    @NotNull
    public GlobalSearchScope getFileResolveScope() {
        DroolsFileSearchScope droolsFileSearchScope = new DroolsFileSearchScope(this);
        if (droolsFileSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/DroolsFile", "getFileResolveScope"));
        }
        return droolsFileSearchScope;
    }

    public boolean ignoreReferencedElementAccessibility() {
        return false;
    }

    public class DroolsFileSearchScope
    extends GlobalSearchScope {
        private DroolsFile myFile;
        private GlobalSearchScope myBaseScope;

        public DroolsFileSearchScope(DroolsFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/drools/lang/psi/DroolsFile$DroolsFileSearchScope", "<init>"));
            }
            super(file.getProject());
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
            this.myBaseScope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.allScope((Project)file.getProject());
            this.myFile = file;
        }

        public DroolsFile getFile() {
            return this.myFile;
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/drools/lang/psi/DroolsFile$DroolsFileSearchScope", "contains"));
            }
            return this.myBaseScope.contains(file);
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/plugins/drools/lang/psi/DroolsFile$DroolsFileSearchScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/plugins/drools/lang/psi/DroolsFile$DroolsFileSearchScope", "compare"));
            }
            return this.myBaseScope.compare(file1, file2);
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/plugins/drools/lang/psi/DroolsFile$DroolsFileSearchScope", "isSearchInModuleContent"));
            }
            return this.myBaseScope.isSearchInModuleContent(aModule);
        }

        public boolean isSearchInLibraries() {
            return this.myBaseScope.isSearchInLibraries();
        }
    }
}

