/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.ListModification;
import org.jetbrains.idea.perforce.application.NumberNameModifier;

public class ModifyComment
implements ListModification<ModifyComment> {
    private final String myNewName;
    @Nullable
    private final String myOldComment;
    @Nullable
    private final String myNewComment;
    private final Long myNumber;

    public ModifyComment(String newName, String oldComment, String newComment, Long number) {
        this.myNewName = newName;
        this.myOldComment = oldComment;
        this.myNewComment = newComment;
        this.myNumber = number;
    }

    public String getNewName() {
        return this.myNewName;
    }

    @Override
    public void execute(Project project, ChangeListManagerGate gate, NumberNameModifier modifier) {
        LocalChangeList existing = gate.findChangeList(this.myNewName);
        if (existing == null) {
            gate.addChangeList(this.myNewName, this.myNewComment);
        } else {
            gate.editComment(this.myNewName, this.myNewComment);
        }
        modifier.add(this.myNewName);
        modifier.put(this.myNewName, this.myNumber);
    }

    @Override
    public boolean doesNothing() {
        return Comparing.equal((String)this.myOldComment, (String)this.myNewComment);
    }
}

