/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002\u001a\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0004\u001a\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0005\u001aI\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\t0\b0\u0007\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\t*\b\u0012\u0004\u0012\u0002H\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\n2\u0006\u0010\f\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"IdentitySet", "", "T", "toIdentitySet", "", "Lkotlin/sequences/Sequence;", "zipWithDefault", "", "Lkotlin/Pair;", "R", "", "other", "defaultT", "(Ljava/lang/Iterable;Ljava/lang/Iterable;Ljava/lang/Object;)Ljava/util/List;", "kotlin-compiler"})
public final class CollectionUtilsKt {
    @NotNull
    public static final <T> Set<T> IdentitySet() {
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        Intrinsics.checkExpressionValueIsNotNull(set, "Collections.newSetFromMa\u2026ityHashMap<T, Boolean>())");
        return set;
    }

    @NotNull
    public static final <T> Set<T> toIdentitySet(@NotNull Collection<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Set<T> result2 = CollectionUtilsKt.IdentitySet();
        for (T element : $receiver) {
            result2.add(element);
        }
        return result2;
    }

    @NotNull
    public static final <T> Set<T> toIdentitySet(@NotNull Sequence<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Set<T> result2 = CollectionUtilsKt.IdentitySet();
        Iterator<T> iterator2 = $receiver.iterator();
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            result2.add(element);
        }
        return result2;
    }

    @NotNull
    public static final <T, R> List<Pair<T, R>> zipWithDefault(@NotNull Iterable<? extends T> $receiver, @NotNull Iterable<? extends R> other, T defaultT) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        Iterator<T> itT = $receiver.iterator();
        Iterator<R> itR = other.iterator();
        ArrayList<Pair> result2 = CollectionsKt.arrayListOf(new Pair[0]);
        while (itT.hasNext() && itR.hasNext()) {
            result2.add(TuplesKt.to(itT.next(), itR.next()));
        }
        boolean bl = !itT.hasNext();
        if (_Assertions.ENABLED && !bl) {
            String string = "First collection is bigger than second";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        while (itR.hasNext()) {
            result2.add(TuplesKt.to(defaultT, itR.next()));
        }
        return result2;
    }
}

