/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalOutputStream;
import com.jediterm.terminal.TtyChannel;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.emulator.Emulator;
import com.jediterm.terminal.emulator.JediEmulator;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class TerminalStarter
implements TerminalOutputStream {
    private static final Logger LOG = Logger.getLogger(TerminalStarter.class);
    private final Emulator myEmulator;
    private final Terminal myTerminal;
    private final TtyChannel myTtyChannel;
    private final TtyConnector myTtyConnector;
    private final ExecutorService myEmulatorExecutor = Executors.newSingleThreadExecutor();

    public TerminalStarter(Terminal terminal, TtyConnector ttyConnector) {
        this.myTtyConnector = ttyConnector;
        this.myTtyChannel = this.createTtyChannel();
        this.myTerminal = terminal;
        this.myTerminal.setTerminalOutput(this);
        this.myEmulator = this.createEmulator(this.myTtyChannel, this, terminal);
    }

    protected JediEmulator createEmulator(TtyChannel channel, TerminalOutputStream stream, Terminal terminal) {
        return new JediEmulator(channel, stream, terminal);
    }

    private TtyChannel createTtyChannel() {
        return new TtyChannel(this.myTtyConnector);
    }

    private void execute(Runnable runnable) {
        if (!this.myEmulatorExecutor.isShutdown()) {
            this.myEmulatorExecutor.execute(runnable);
        }
    }

    public void start() {
        try {
            while (!Thread.currentThread().isInterrupted() && this.myEmulator.hasNext()) {
                this.myEmulator.next();
            }
        }
        catch (InterruptedIOException e) {
            LOG.info((Object)"Terminal exiting");
        }
        catch (Exception e) {
            if (!this.myTtyChannel.isConnected()) {
                this.myTerminal.disconnected();
                return;
            }
            LOG.error((Object)"Caught exception in terminal thread", (Throwable)e);
        }
    }

    public byte[] getCode(int key, int modifiers) {
        return this.myTerminal.getCodeForKey(key, modifiers);
    }

    public void postResize(final Dimension dimension, final RequestOrigin origin) {
        this.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Dimension pixelSize;
                Terminal terminal = TerminalStarter.this.myTerminal;
                synchronized (terminal) {
                    pixelSize = TerminalStarter.this.myTerminal.resize(dimension, origin);
                }
                TerminalStarter.this.myTtyChannel.postResize(dimension, pixelSize);
            }
        });
    }

    @Override
    public void sendBytes(final byte[] bytes) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TerminalStarter.this.myTtyChannel.sendBytes(bytes);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void sendString(final String string) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TerminalStarter.this.myTtyChannel.sendString(string);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void close() {
        this.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TerminalStarter.this.myTtyConnector.close();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error closing terminal", (Throwable)e);
                }
                finally {
                    TerminalStarter.this.myEmulatorExecutor.shutdown();
                }
            }
        });
    }
}

