/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.jediterm.terminal.ui.TerminalActionProvider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class TerminalAction {
    private final String myName;
    private final KeyStroke[] myKeyStrokes;
    private final Predicate<KeyEvent> myRunnable;
    private Character myMnemonic = null;
    private Supplier<Boolean> myEnabledSupplier = null;
    private Integer myMnemonicKey = null;
    private boolean mySeparatorBefore = false;

    public TerminalAction(String name, KeyStroke[] keyStrokes, Predicate<KeyEvent> runnable) {
        this.myName = name;
        this.myKeyStrokes = keyStrokes;
        this.myRunnable = runnable;
    }

    public boolean matches(KeyEvent e) {
        for (KeyStroke ks : this.myKeyStrokes) {
            if (!ks.equals(KeyStroke.getKeyStrokeForEvent(e))) continue;
            return true;
        }
        return false;
    }

    public boolean perform(KeyEvent e) {
        if (this.myEnabledSupplier != null && !((Boolean)this.myEnabledSupplier.get()).booleanValue()) {
            return false;
        }
        return this.myRunnable.apply((Object)e);
    }

    public static boolean processEvent(TerminalActionProvider actionProvider, KeyEvent e) {
        for (TerminalAction a : actionProvider.getActions()) {
            if (!a.matches(e)) continue;
            return a.perform(e);
        }
        if (actionProvider.getNextProvider() != null) {
            return TerminalAction.processEvent(actionProvider.getNextProvider(), e);
        }
        return false;
    }

    public static boolean addToMenu(JPopupMenu menu, TerminalActionProvider actionProvider) {
        boolean added = false;
        if (actionProvider.getNextProvider() != null) {
            added = TerminalAction.addToMenu(menu, actionProvider.getNextProvider());
        }
        boolean addSeparator = added;
        for (TerminalAction a : actionProvider.getActions()) {
            if (!addSeparator) {
                addSeparator = a.isSeparated();
            }
            if (addSeparator) {
                menu.addSeparator();
                addSeparator = false;
            }
            menu.add(a.toMenuItem());
            added = true;
        }
        return added;
    }

    public int getKeyCode() {
        int n = 0;
        KeyStroke[] keyStrokeArray = this.myKeyStrokes;
        int n2 = keyStrokeArray.length;
        if (n < n2) {
            KeyStroke ks = keyStrokeArray[n];
            return ks.getKeyCode();
        }
        return 0;
    }

    public int getModifiers() {
        int n = 0;
        KeyStroke[] keyStrokeArray = this.myKeyStrokes;
        int n2 = keyStrokeArray.length;
        if (n < n2) {
            KeyStroke ks = keyStrokeArray[n];
            return ks.getModifiers();
        }
        return 0;
    }

    public String getName() {
        return this.myName;
    }

    public TerminalAction withMnemonic(Character ch) {
        this.myMnemonic = ch;
        return this;
    }

    public TerminalAction withMnemonicKey(Integer key) {
        this.myMnemonicKey = key;
        return this;
    }

    public boolean isEnabled() {
        if (this.myEnabledSupplier != null) {
            return (Boolean)this.myEnabledSupplier.get();
        }
        return true;
    }

    public TerminalAction withEnabledSupplier(Supplier<Boolean> enabledSupplier) {
        this.myEnabledSupplier = enabledSupplier;
        return this;
    }

    public TerminalAction separatorBefore(boolean enabled) {
        this.mySeparatorBefore = enabled;
        return this;
    }

    public JMenuItem toMenuItem() {
        JMenuItem menuItem = new JMenuItem(this.myName);
        if (this.myMnemonic != null) {
            menuItem.setMnemonic(this.myMnemonic.charValue());
        }
        if (this.myMnemonicKey != null) {
            menuItem.setMnemonic(this.myMnemonicKey);
        }
        if (this.myKeyStrokes.length > 0) {
            menuItem.setAccelerator(this.myKeyStrokes[0]);
        }
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerminalAction.this.myRunnable.apply(null);
            }
        });
        menuItem.setEnabled(this.isEnabled());
        return menuItem;
    }

    public boolean isSeparated() {
        return this.mySeparatorBefore;
    }
}

