/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.firefoxConnector;

import com.intellij.firefoxConnector.configuration.FirefoxExtensionUtil;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import com.jetbrains.browserConnection.BrowserConnector;
import com.jetbrains.browserConnection.BrowserQualifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

class FirefoxConnector
extends BrowserConnector {
    FirefoxConnector() {
    }

    public boolean canHandle(@NotNull BrowserQualifier browserQualifier) {
        if (browserQualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserQualifier", "com/intellij/firefoxConnector/FirefoxConnector", "canHandle"));
        }
        return browserQualifier.equals((Object)BrowserQualifier.FIREFOX);
    }

    @NotNull
    public Promise<Void> ensureExtensionInstalled(@NotNull WebBrowser browser, @Nullable Project project) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/firefoxConnector/FirefoxConnector", "ensureExtensionInstalled"));
        }
        Promise<Void> promise = FirefoxExtensionUtil.ensureFirefoxExtensionInstalled(project);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/firefoxConnector/FirefoxConnector", "ensureExtensionInstalled"));
        }
        return promise;
    }

    public String[] getLaunchParameters() {
        if (SystemProperties.getBooleanProperty((String)"idea.js.debugger.firefox.no.remote", (boolean)false)) {
            return new String[]{"-no-remote"};
        }
        return super.getLaunchParameters();
    }

    public void checkVersion(@NotNull WebBrowser browser, String version, @Nullable Project project) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/firefoxConnector/FirefoxConnector", "checkVersion"));
        }
    }
}

