/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.action;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.OpenSourceUtil;
import icons.Struts2Icons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateActionMethodQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements Iconable {
    private static final Logger LOG = Logger.getInstance((String)CreateActionMethodQuickFix.class.getSimpleName());
    private final String methodName;

    public CreateActionMethodQuickFix(PsiClass actionClass, String methodName) {
        super((PsiElement)actionClass);
        this.methodName = methodName;
    }

    @NotNull
    public String getText() {
        String string = "Create action-method '" + this.methodName + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/action/CreateActionMethodQuickFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Create action-method" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/action/CreateActionMethodQuickFix", "getFamilyName"));
        }
        return "Create action-method";
    }

    public Icon getIcon(int flags) {
        return Struts2Icons.Action;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startPsiElement, @NotNull PsiElement endPsiElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/struts2/dom/struts/action/CreateActionMethodQuickFix", "invoke"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/struts2/dom/struts/action/CreateActionMethodQuickFix", "invoke"));
        }
        if (startPsiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startPsiElement", "com/intellij/struts2/dom/struts/action/CreateActionMethodQuickFix", "invoke"));
        }
        if (endPsiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endPsiElement", "com/intellij/struts2/dom/struts/action/CreateActionMethodQuickFix", "invoke"));
        }
        try {
            PsiClass actionClass = (PsiClass)startPsiElement;
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)actionClass.getContainingFile())) {
                return;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiMethod actionMethod = elementFactory.createMethodFromText("public java.lang.String " + this.methodName + "() throws java.lang.Exception { return \"success\"; }", (PsiElement)actionClass);
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            actionMethod = (PsiMethod)javaCodeStyleManager.shortenClassReferences((PsiElement)actionMethod);
            CodeStyleManager codestylemanager = CodeStyleManager.getInstance((Project)project);
            actionMethod = (PsiMethod)codestylemanager.reformat((PsiElement)actionMethod);
            PsiMethod element = (PsiMethod)actionClass.add((PsiElement)actionMethod);
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)element.getBody().getNavigationElement()});
        }
        catch (IncorrectOperationException e) {
            LOG.error("creation of action-method failed", (Throwable)e);
        }
    }
}

