/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.validator.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.xml.XmlElement;
import com.intellij.struts2.dom.validator.FieldNameConverter;
import com.intellij.struts2.reference.common.BeanPropertyPathReference;
import com.intellij.struts2.reference.common.BeanPropertyPathReferenceSet;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FieldNameConverterImpl
extends FieldNameConverter {
    protected PsiClass findBeanPropertyClass(@NotNull DomElement domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/struts2/dom/validator/impl/FieldNameConverterImpl", "findBeanPropertyClass"));
        }
        XmlElement xmlElement = domElement.getXmlElement();
        assert (xmlElement != null);
        PsiFile psiFile = xmlElement.getContainingFile().getOriginalFile();
        PsiDirectory containingDirectory = psiFile.getContainingDirectory();
        if (containingDirectory == null) {
            return null;
        }
        PsiPackage containingPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory);
        if (containingPackage == null) {
            return null;
        }
        String validationFileName = psiFile.getName();
        String actionClassName = (String)StringUtil.split((String)validationFileName, (String)"-").get(0);
        String qualifiedActionClassName = StringUtil.getQualifiedName((String)containingPackage.getQualifiedName(), (String)actionClassName);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)psiFile.getProject());
        return psiFacade.findClass(qualifiedActionClassName, (GlobalSearchScope)new PackageScope(containingPackage, false, false));
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<List<BeanProperty>> listGenericDomValue, PsiElement psiElement, ConvertContext convertContext) {
        PsiClass actionClass = this.findBeanPropertyClass(convertContext.getInvocationElement());
        BeanPropertyPathReference[] beanPropertyPathReferenceArray = new BeanPropertyPathReferenceSet(psiElement, actionClass, false).getPsiReferences();
        if (beanPropertyPathReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/validator/impl/FieldNameConverterImpl", "createReferences"));
        }
        return beanPropertyPathReferenceArray;
    }
}

