/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.pathVariables;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.spring.web.mvc.pathVariables.MVCPathVariableReference;
import com.intellij.spring.web.mvc.pathVariables.MVCRequestMappingReference;
import org.jetbrains.annotations.NotNull;

public class MVCPathVariableInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                block4: {
                    PsiReference[] references;
                    block3: {
                        if (!JamCommonUtil.isPlainJavaFile((PsiElement)expression.getContainingFile())) {
                            return;
                        }
                        if (!MVCPathVariableReference.PATTERN.accepts((Object)expression)) break block3;
                        for (PsiReference reference : expression.getReferences()) {
                            if (!(reference instanceof MVCPathVariableReference) || ((MVCPathVariableReference)reference).multiResolve(false).length != 0) continue;
                            holder.registerProblem(reference);
                            return;
                        }
                        break block4;
                    }
                    if (!MVCRequestMappingReference.PATTERN.accepts((Object)expression)) break block4;
                    for (PsiReference reference : references = expression.getReferences()) {
                        if (!(reference instanceof MVCRequestMappingReference) || reference.resolve() != null) continue;
                        holder.registerProblem(reference);
                        return;
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @NotNull
    public String getShortName() {
        if ("MVCPathVariableInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableInspection", "getShortName"));
        }
        return "MVCPathVariableInspection";
    }
}

