/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.interfaces.mochaTdd;

import com.google.common.collect.ImmutableList;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.AbstractMochaTddElement;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddSuite;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddTest;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaTddFileStructureBuilder
extends AbstractTestFileStructureBuilder<MochaTddFileStructure> {
    private static final String SUITE_NAME = "suite";
    private static final String TEST_NAME = "test";
    private static final MochaTddFileStructureBuilder INSTANCE = new MochaTddFileStructureBuilder();

    public static MochaTddFileStructureBuilder getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public MochaTddFileStructure buildTestFileStructure(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructureBuilder", "buildTestFileStructure"));
        }
        Object children = ImmutableList.of();
        if (JsPsiUtils.mightContainGlobalCall((PsiFile)jsFile, SUITE_NAME, false)) {
            children = ContainerUtil.newSmartList();
            List<JSStatement> statements = JsPsiUtils.listStatementsInExecutionOrder(jsFile);
            for (JSStatement statement : statements) {
                JSCallExpression callExpr = JsPsiUtils.toCallExpressionFromStatement(statement);
                if (callExpr == null) continue;
                this.handleCallExpr(null, callExpr, (List<AbstractMochaTddElement>)children);
            }
        }
        MochaTddFileStructure mochaTddFileStructure = new MochaTddFileStructure(jsFile, (List<AbstractMochaTddElement>)children);
        if (mochaTddFileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructureBuilder", "buildTestFileStructure"));
        }
        return mochaTddFileStructure;
    }

    private void handleCallExpr(@Nullable MochaTddSuite parentSuite, @NotNull JSCallExpression callExpr, @NotNull List<AbstractMochaTddElement> children) {
        if (callExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpr", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructureBuilder", "handleCallExpr"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructureBuilder", "handleCallExpr"));
        }
        JSReferenceExpression methodRefExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpr.getMethodExpression(), JSReferenceExpression.class);
        if (methodRefExpr != null && methodRefExpr.getQualifier() == null) {
            String testName;
            JSFunctionExpression testDefinitions;
            String suiteName;
            JSExpression[] arguments = callExpr.getArguments();
            if (arguments.length != 2) {
                return;
            }
            String methodName = methodRefExpr.getReferenceName();
            if (SUITE_NAME.equals(methodName) && (suiteName = JsPsiUtils.extractStringValue(arguments[0])) != null && (testDefinitions = JsPsiUtils.extractFunctionExpression(arguments[1])) != null) {
                MochaTddSuite suite = new MochaTddSuite(suiteName, callExpr, parentSuite);
                children.add(suite);
                int suiteInd = children.size() - 1;
                this.handleSuite(suite, testDefinitions, children);
                if (children.get(suiteInd) != suite) {
                    throw new AssertionError((Object)"Cannot find self in list");
                }
                suite.setChildren(children.subList(suiteInd + 1, children.size()));
                while (suiteInd + 1 != children.size()) {
                    children.remove(children.size() - 1);
                }
            }
            if (TEST_NAME.equals(methodName) && (testName = JsPsiUtils.extractStringValue(arguments[0])) != null) {
                MochaTddTest test = new MochaTddTest(testName, callExpr, parentSuite);
                children.add(test);
            }
        }
    }

    private void handleSuite(@NotNull MochaTddSuite suite, @NotNull JSFunctionExpression specDefinitions, @NotNull List<AbstractMochaTddElement> children) {
        JSSourceElement[] sourceElements;
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SUITE_NAME, "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructureBuilder", "handleSuite"));
        }
        if (specDefinitions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specDefinitions", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructureBuilder", "handleSuite"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructureBuilder", "handleSuite"));
        }
        for (JSSourceElement sourceElement : sourceElements = (JSSourceElement[])ObjectUtils.notNull((Object)specDefinitions.getBody(), (Object)JSSourceElement.EMPTY_ARRAY)) {
            JSStatement[] statements;
            JSBlockStatement blockStatement = (JSBlockStatement)ObjectUtils.tryCast((Object)sourceElement, JSBlockStatement.class);
            if (blockStatement == null) continue;
            for (JSStatement statement : statements = (JSStatement[])ObjectUtils.notNull((Object)blockStatement.getStatements(), (Object)JSStatement.EMPTY)) {
                JSCallExpression callExpr = JsPsiUtils.toCallExpressionFromStatement(statement);
                if (callExpr == null) continue;
                this.handleCallExpr(suite, callExpr, children);
            }
        }
    }
}

