/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import org.intellij.idea.lang.javascript.intention.initialization.JSVariablesWithInitializerPredicate;
import org.jetbrains.annotations.NotNull;

public class FlowJSVariablePredicate
extends JSVariablesWithInitializerPredicate {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        JSVariable variable;
        JSFunction function;
        JSFunctionExpression expression;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSVariablePredicate", "satisfiedBy"));
        }
        if (element.getParent() instanceof JSParameter || element.getParent() instanceof JSParameterList) {
            JSParameter parameter;
            if (element.getParent() instanceof JSParameterList) {
                if (!(element.getPrevSibling() instanceof JSParameter)) return false;
                parameter = (JSParameter)element.getPrevSibling();
            } else {
                parameter = (JSParameter)element.getParent();
            }
            if (parameter.getTypeElement() != null) return false;
            return true;
        }
        if (!(element.getParent() instanceof JSFunctionExpression || element.getParent() instanceof JSFunction ? (element.getParent() instanceof JSFunctionExpression ? (expression = (JSFunctionExpression)element.getParent()).getReturnTypeElement() == null : (function = (JSFunction)element.getParent()).getReturnTypeElement() == null) : element.getParent() instanceof JSVariable && (variable = (JSVariable)element.getParent()).getTypeElement() == null)) return false;
        return true;
    }
}

