/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import org.intellij.idea.lang.javascript.intention.initialization.JSVariablesWithInitializerPredicate;
import org.jetbrains.annotations.NotNull;

abstract class TypeScriptVariablePredicate
implements JSElementPredicate {
    TypeScriptVariablePredicate() {
    }

    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/TypeScriptVariablePredicate", "satisfiedBy"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!(element instanceof TypeScriptVariable)) {
            return false;
        }
        PsiElement statement = element.getParent();
        if (ErrorUtil.containsError((PsiElement)statement)) {
            return false;
        }
        if (!JSVariablesWithInitializerPredicate.isRegularVariableContext(statement.getParent())) {
            return false;
        }
        TypeScriptVariable variable = (TypeScriptVariable)element;
        return this.checkVariable(variable);
    }

    protected abstract boolean checkVariable(TypeScriptVariable var1);
}

