/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.string;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;

public class StringUtil {
    public static final char SIMPLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char BACKSLASH = '\\';

    private StringUtil() {
    }

    public static boolean isSingleQuoteStringLiteral(PsiElement expression) {
        String value = expression.getText();
        return value != null && value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'';
    }

    public static boolean isDoubleQuoteStringLiteral(PsiElement expression) {
        String value = expression.getText();
        return value != null && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    static PsiElement getElementToReplaceQuotes(PsiElement element) {
        assert (element instanceof JSLiteralExpression || element.getNode().getElementType() == JSTokenTypes.STRING_LITERAL);
        ASTNode literalExpr = JSChangeUtil.createExpressionFromText((Project)element.getProject(), (String)StringUtil.changeQuotes(element.getText()), (JSLanguageDialect)JavaScriptSupportLoader.JAVASCRIPT_1_5);
        return element instanceof JSLiteralExpression ? literalExpr.getPsi() : literalExpr.getFirstChildNode().getPsi();
    }

    static String changeQuotes(String jsStringLiteral) {
        char newQuote;
        char oldQuote;
        if (jsStringLiteral.startsWith("'")) {
            oldQuote = '\'';
            newQuote = '\"';
        } else if (jsStringLiteral.startsWith("\"")) {
            oldQuote = '\"';
            newQuote = '\'';
        } else {
            return jsStringLiteral;
        }
        StringBuilder buffer = new StringBuilder(jsStringLiteral);
        boolean screened = false;
        int bufferIndex = 1;
        for (int i = 1; i < jsStringLiteral.length() - 1; ++i) {
            char c = jsStringLiteral.charAt(i);
            if (screened) {
                if (c == oldQuote) {
                    buffer.deleteCharAt(bufferIndex - 1);
                } else {
                    ++bufferIndex;
                }
                screened = false;
                continue;
            }
            if (c == '\\') {
                screened = true;
            } else if (c == newQuote) {
                buffer.insert(bufferIndex++, '\\');
            }
            ++bufferIndex;
        }
        buffer.setCharAt(0, newQuote);
        buffer.setCharAt(buffer.length() - 1, newQuote);
        return buffer.toString();
    }
}

