/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsUser;
import git4idea.DialogManager;
import git4idea.history.GitHistoryUtils;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class GitRebaseOverMergeProblem {
    private static final Logger LOG = Logger.getInstance(GitRebaseOverMergeProblem.class);
    public static final String DESCRIPTION = "You are about to rebase merge commits. \nThis can lead to duplicate commits in history, or even data loss.\nIt is recommended to merge instead of rebase in this case.";

    public static boolean hasProblem(@NotNull Project project, @NotNull VirtualFile root, @NotNull String baseRef, @NotNull String currentRef) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/update/GitRebaseOverMergeProblem", "hasProblem"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/update/GitRebaseOverMergeProblem", "hasProblem"));
        }
        if (baseRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseRef", "git4idea/update/GitRebaseOverMergeProblem", "hasProblem"));
        }
        if (currentRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRef", "git4idea/update/GitRebaseOverMergeProblem", "hasProblem"));
        }
        final Ref mergeFound = Ref.create((Object)Boolean.FALSE);
        Consumer<TimedVcsCommit> detectingConsumer = new Consumer<TimedVcsCommit>(){

            public void consume(TimedVcsCommit commit) {
                mergeFound.set((Object)true);
            }
        };
        String range = baseRef + ".." + currentRef;
        try {
            GitHistoryUtils.readCommits(project, root, Arrays.asList(range, "--merges"), (Consumer<VcsUser>)EmptyConsumer.getInstance(), (Consumer<VcsRef>)EmptyConsumer.getInstance(), detectingConsumer);
        }
        catch (VcsException e) {
            LOG.warn("Couldn't get git log --merges " + range, (Throwable)e);
        }
        return (Boolean)mergeFound.get();
    }

    @NotNull
    public static Decision showDialog() {
        Ref decision = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> decision.set((Object)GitRebaseOverMergeProblem.doShowDialog()));
        Decision decision2 = (Decision)((Object)decision.get());
        if (decision2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitRebaseOverMergeProblem", "showDialog"));
        }
        return decision2;
    }

    @NotNull
    private static Decision doShowDialog() {
        int decision = DialogManager.showMessage(DESCRIPTION, "Rebasing Merge Commits", Decision.getButtonTitles(), Decision.getDefaultButtonIndex(), Decision.getFocusedButtonIndex(), Messages.getWarningIcon(), null);
        Decision decision2 = Decision.getOption(decision);
        if (decision2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitRebaseOverMergeProblem", "doShowDialog"));
        }
        return decision2;
    }

    public static enum Decision {
        MERGE_INSTEAD("Merge"),
        REBASE_ANYWAY("Rebase Anyway"),
        CANCEL_OPERATION(CommonBundle.getCancelButtonText());

        private final String myButtonText;

        private Decision(String buttonText) {
            if (buttonText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buttonText", "git4idea/update/GitRebaseOverMergeProblem$Decision", "<init>"));
            }
            this.myButtonText = buttonText;
        }

        @NotNull
        private static String[] getButtonTitles() {
            String[] stringArray = (String[])ContainerUtil.map2Array((Object[])Decision.values(), String.class, (Function)new Function<Decision, String>(){

                public String fun(Decision decision) {
                    return decision.myButtonText;
                }
            });
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitRebaseOverMergeProblem$Decision", "getButtonTitles"));
            }
            return stringArray;
        }

        @NotNull
        public static Decision getOption(final int index) {
            Decision decision = (Decision)((Object)ObjectUtils.assertNotNull((Object)ContainerUtil.find((Object[])Decision.values(), (Condition)new Condition<Decision>(){

                public boolean value(Decision decision) {
                    return decision.ordinal() == index;
                }
            })));
            if (decision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitRebaseOverMergeProblem$Decision", "getOption"));
            }
            return decision;
        }

        private static int getDefaultButtonIndex() {
            return MERGE_INSTEAD.ordinal();
        }

        private static int getFocusedButtonIndex() {
            return CANCEL_OPERATION.ordinal();
        }
    }
}

