/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.InterruptedRuntimeException;
import com.jogamp.common.util.SourcedInterruptedException;
import com.jogamp.common.util.locks.SingletonInstance;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class SingletonInstanceServerSocket
extends SingletonInstance {
    private static int serverInstanceCount = 0;
    private final Server singletonServer;
    private final String fullName;

    public SingletonInstanceServerSocket(long l, int n) {
        super(l);
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(null);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (null == inetAddress) {
            try {
                inetAddress = InetAddress.getByName("localhost");
                if (null != inetAddress && !inetAddress.isLoopbackAddress()) {
                    inetAddress = null;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (null == inetAddress) {
            try {
                inetAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
                if (null != inetAddress && !inetAddress.isLoopbackAddress()) {
                    inetAddress = null;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (null == inetAddress) {
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (null == inetAddress) {
            throw new RuntimeException(String.valueOf(this.infoPrefix()).concat(" EEE Could not determine local InetAddress"));
        }
        String string = String.valueOf(inetAddress.toString());
        this.fullName = new StringBuilder(12 + String.valueOf(string).length()).append(string).append(":").append(n).toString();
        this.singletonServer = new Server(inetAddress, n);
        Runtime.getRuntime().addShutdownHook(new InterruptSource.Thread(){

            @Override
            public void run() {
                SingletonInstanceServerSocket.this.singletonServer.kill();
            }
        });
    }

    public final InetAddress getLocalInetAddress() {
        return this.singletonServer.getLocalInetAddress();
    }

    public final int getPortNumber() {
        return this.singletonServer.getPortNumber();
    }

    @Override
    public final String getName() {
        return this.fullName;
    }

    @Override
    protected boolean tryLockImpl() {
        if (this.singletonServer.isRunning()) {
            return false;
        }
        Socket socket = this.singletonServer.connect();
        if (null != socket) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        return this.singletonServer.start();
    }

    @Override
    protected boolean unlockImpl() {
        return this.singletonServer.shutdown();
    }

    public class Server
    implements Runnable {
        private final InetAddress localInetAddress;
        private final int portNumber;
        private volatile boolean shallQuit = false;
        private volatile boolean alive = false;
        private final Object syncOnStartStop = new Object();
        private ServerSocket serverSocket = null;
        private Thread serverThread = null;

        public Server(InetAddress inetAddress, int n) {
            this.localInetAddress = inetAddress;
            this.portNumber = n;
        }

        public final InetAddress getLocalInetAddress() {
            return this.localInetAddress;
        }

        public final int getPortNumber() {
            return this.portNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean start() {
            if (this.alive) {
                return true;
            }
            Object object = Server.class;
            synchronized (Server.class) {
                serverInstanceCount++;
                int n = serverInstanceCount;
                Object object2 = SingletonInstanceServerSocket.this.fullName;
                String string = new StringBuilder(33 + String.valueOf(object2).length()).append("SingletonServerSocket").append(n).append("-").append((String)object2).toString();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                object = this.syncOnStartStop;
                synchronized (object) {
                    this.shallQuit = false;
                    this.serverThread = new InterruptSource.Thread(null, this, string);
                    this.serverThread.setDaemon(true);
                    this.serverThread.start();
                    try {
                        while (!this.alive && !this.shallQuit) {
                            this.syncOnStartStop.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        object2 = SourcedInterruptedException.wrap(interruptedException);
                        this.shutdown(false);
                        throw new InterruptedRuntimeException((InterruptedException)object2);
                    }
                }
                boolean bl = this.isBound();
                if (!bl) {
                    this.shutdown(true);
                }
                return bl;
            }
        }

        public final boolean shutdown() {
            return this.shutdown(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean shutdown(boolean bl) {
            Object object;
            if (!this.alive) {
                return true;
            }
            try {
                object = this.syncOnStartStop;
                synchronized (object) {
                    this.shallQuit = true;
                    this.connect();
                    if (bl) {
                        try {
                            while (this.alive) {
                                this.syncOnStartStop.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            throw new InterruptedRuntimeException(interruptedException);
                        }
                    }
                }
            }
            finally {
                if (this.alive) {
                    object = SingletonInstanceServerSocket.this.infoPrefix();
                    String string = SingletonInstanceServerSocket.this.getName();
                    System.err.println(new StringBuilder(57 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(" EEE ").append(string).append(" - Unable to remove lock: ServerThread still alive ?").toString());
                    this.kill();
                }
            }
            return true;
        }

        public final void kill() {
            Object object;
            if (this.alive) {
                object = SingletonInstanceServerSocket.this.infoPrefix();
                String string = SingletonInstanceServerSocket.this.getName();
                System.err.println(new StringBuilder(27 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(" XXX ").append(string).append(" - Kill @ JVM Shutdown").toString());
            }
            this.alive = false;
            this.shallQuit = false;
            if (null != this.serverThread && this.serverThread.isAlive()) {
                try {
                    this.serverThread.stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (null != this.serverSocket) {
                try {
                    object = this.serverSocket;
                    this.serverSocket = null;
                    ((ServerSocket)object).close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public final boolean isRunning() {
            return this.alive;
        }

        public final boolean isBound() {
            return this.alive && null != this.serverSocket && this.serverSocket.isBound();
        }

        public final Socket connect() {
            try {
                return new Socket(this.localInetAddress, this.portNumber);
            }
            catch (Exception exception) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String string;
            Object object;
            System.err.println(String.valueOf(SingletonInstanceServerSocket.this.infoPrefix()).concat(" III - Start"));
            try {
                String string2;
                object = this.syncOnStartStop;
                synchronized (object) {
                    try {
                        this.serverSocket = new ServerSocket(this.portNumber, 1, this.localInetAddress);
                        this.serverSocket.setReuseAddress(true);
                        this.alive = true;
                    }
                    catch (IOException iOException) {
                        string2 = SingletonInstanceServerSocket.this.infoPrefix();
                        String string3 = String.valueOf(iOException.getMessage());
                        System.err.println(new StringBuilder(39 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" III - Unable to install ServerSocket: ").append(string3).toString());
                        this.shallQuit = true;
                    }
                    finally {
                        this.syncOnStartStop.notifyAll();
                    }
                }
                while (!this.shallQuit) {
                    try {
                        object = this.serverSocket.accept();
                        ((Socket)object).close();
                    }
                    catch (IOException iOException) {
                        string = SingletonInstanceServerSocket.this.infoPrefix();
                        string2 = String.valueOf(iOException.getMessage());
                        System.err.println(new StringBuilder(32 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" EEE - Exception during accept: ").append(string2).toString());
                    }
                }
                object = this.syncOnStartStop;
            }
            catch (ThreadDeath threadDeath) {
                Object object2;
                try {
                    ExceptionUtils.dumpThrowable("", threadDeath);
                    object2 = this.syncOnStartStop;
                }
                catch (Throwable throwable) {
                    Object object3 = this.syncOnStartStop;
                    synchronized (object3) {
                        String string4 = SingletonInstanceServerSocket.this.infoPrefix();
                        boolean bl = this.alive;
                        boolean bl2 = this.shallQuit;
                        boolean bl3 = null != this.serverSocket;
                        System.err.println(new StringBuilder(62 + String.valueOf(string4).length()).append(string4).append(" III - Stopping: alive ").append(bl).append(", shallQuit ").append(bl2).append(", hasSocket ").append(bl3).toString());
                        if (null != this.serverSocket) {
                            try {
                                this.serverSocket.close();
                            }
                            catch (IOException iOException) {
                                String string5 = SingletonInstanceServerSocket.this.infoPrefix();
                                String string6 = String.valueOf(iOException.getMessage());
                                System.err.println(new StringBuilder(31 + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string5).append(" EEE - Exception during close: ").append(string6).toString());
                            }
                        }
                        this.serverSocket = null;
                        this.alive = false;
                        this.syncOnStartStop.notifyAll();
                    }
                    throw throwable;
                }
                synchronized (object2) {
                    String string7 = SingletonInstanceServerSocket.this.infoPrefix();
                    boolean bl = this.alive;
                    boolean bl4 = this.shallQuit;
                    boolean bl5 = null != this.serverSocket;
                    System.err.println(new StringBuilder(62 + String.valueOf(string7).length()).append(string7).append(" III - Stopping: alive ").append(bl).append(", shallQuit ").append(bl4).append(", hasSocket ").append(bl5).toString());
                    if (null != this.serverSocket) {
                        try {
                            this.serverSocket.close();
                        }
                        catch (IOException iOException) {
                            String string8 = SingletonInstanceServerSocket.this.infoPrefix();
                            String string9 = String.valueOf(iOException.getMessage());
                            System.err.println(new StringBuilder(31 + String.valueOf(string8).length() + String.valueOf(string9).length()).append(string8).append(" EEE - Exception during close: ").append(string9).toString());
                        }
                    }
                    this.serverSocket = null;
                    this.alive = false;
                    this.syncOnStartStop.notifyAll();
                }
            }
            synchronized (object) {
                string = SingletonInstanceServerSocket.this.infoPrefix();
                boolean bl = this.alive;
                boolean bl6 = this.shallQuit;
                boolean bl7 = null != this.serverSocket;
                System.err.println(new StringBuilder(62 + String.valueOf(string).length()).append(string).append(" III - Stopping: alive ").append(bl).append(", shallQuit ").append(bl6).append(", hasSocket ").append(bl7).toString());
                if (null != this.serverSocket) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException iOException) {
                        String string10 = SingletonInstanceServerSocket.this.infoPrefix();
                        String string11 = String.valueOf(iOException.getMessage());
                        System.err.println(new StringBuilder(31 + String.valueOf(string10).length() + String.valueOf(string11).length()).append(string10).append(" EEE - Exception during close: ").append(string11).toString());
                    }
                }
                this.serverSocket = null;
                this.alive = false;
                this.syncOnStartStop.notifyAll();
            }
        }
    }
}

