/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.applicationServer;

import com.intellij.j2ee.webSphere.configuration.WebSphereCell;
import com.intellij.j2ee.webSphere.configuration.WebSphereLibertyFilesProvider;
import com.intellij.j2ee.webSphere.configuration.WebSphereNode;
import com.intellij.j2ee.webSphere.configuration.WebSphereProfile;
import com.intellij.j2ee.webSphere.configuration.WebSphereProfileUtil;
import com.intellij.j2ee.webSphere.configuration.WebSphereServerConfiguration;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersion;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersionUtil;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereLocalModel;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.oss.server.ServerSupportContributorBase;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.supportProvider.JavaeeFrameworkSupportContributionModel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;

public class WebSphereServerSupportContributor
extends ServerSupportContributorBase<WebSphereLocalModel> {
    public WebSphereServerSupportContributor() {
        super(WebSphereLocalModel.class);
    }

    protected void doSetupServerRunConfiguration(WebSphereLocalModel serverModel, CommonModel commonModel, JavaeeFrameworkSupportContributionModel frameworkModel) {
        ApplicationServer applicationServer = commonModel.getApplicationServer();
        WebSphereVersion version = WebSphereVersionUtil.createVersion(applicationServer);
        if (version == null) {
            return;
        }
        if (version.isLibertyProfile()) {
            String serverName = (String)ContainerUtil.getFirstItem(new WebSphereLibertyFilesProvider(applicationServer).getServerNames());
            if (serverName != null) {
                serverModel.SERVER_NAME = serverName;
            }
        } else {
            WebSphereProfile webSphereProfile = (WebSphereProfile)ArrayUtil.getFirstElement((Object[])WebSphereProfileUtil.getProfiles(version));
            if (webSphereProfile == null) {
                return;
            }
            serverModel.PROFILE_PATH = webSphereProfile.getLocation().getAbsolutePath();
            WebSphereCell cell = (WebSphereCell)ArrayUtil.getFirstElement((Object[])webSphereProfile.getCells());
            if (cell == null) {
                return;
            }
            serverModel.CELL_NAME = cell.getCellName();
            WebSphereNode node = (WebSphereNode)ArrayUtil.getFirstElement((Object[])cell.getNodes());
            if (node == null) {
                return;
            }
            serverModel.NODE_NAME = node.getNodeName();
            WebSphereServerConfiguration serverConfiguration = (WebSphereServerConfiguration)ArrayUtil.getFirstElement((Object[])node.getServers());
            if (serverConfiguration == null) {
                return;
            }
            serverModel.SERVER_NAME = serverConfiguration.getServerName();
        }
    }
}

