/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references;

import com.intellij.jsf.references.JsfXmlAttributeReferencesProvider;
import com.intellij.jsf.references.JsfXmlAttributeSimpleResourceReference;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.XmlTagFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JsfResourceIdentifierAttributeReferencesProvider
extends JsfXmlAttributeReferencesProvider {
    @NonNls
    private static final String JSF_LIBRARY_NAME_ATTR_NAME = "name";

    @Override
    public String[] getAttributeNames() {
        return new String[]{JSF_LIBRARY_NAME_ATTR_NAME};
    }

    @Override
    protected PsiReference[] createReferences(@NotNull XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
        if (xmlAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "com/intellij/jsf/references/JsfResourceIdentifierAttributeReferencesProvider", "createReferences"));
        }
        String value = xmlAttributeValue.getValue();
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (value.contains("/")) {
            String libraryName;
            XmlAttributeValue libraryAttributeValue = JsfXmlAttributeSimpleResourceReference.getLibraryAttributeValue((XmlElement)xmlAttributeValue);
            if (libraryAttributeValue != null && (libraryName = libraryAttributeValue.getValue()) != null) {
                Set<PsiDirectory> resourceLibraryDirectories = JsfCommonUtils.getResourceLibraryDirectoriesWithVersions(ModuleUtilCore.findModuleForPsiElement((PsiElement)xmlAttributeValue), libraryName);
                return JsfCommonUtils.createResourceIdentifierReferences(value, (PsiElement)xmlAttributeValue, resourceLibraryDirectories);
            }
            return JsfCommonUtils.createTopLevelResourceIdentifierReferences(value, (PsiElement)xmlAttributeValue);
        }
        return new PsiReference[]{new JsfXmlAttributeSimpleResourceReference(xmlAttributeValue)};
    }

    @Override
    public ElementFilter getElementFilter() {
        return new ParentElementFilter((ElementFilter)new AndFilter((ElementFilter)new AndFilter((ElementFilter)XmlTagFilter.INSTANCE, (ElementFilter)new TextFilter(new String[]{"outputScript", "outputStylesheet", "graphicImage"})), (ElementFilter)new NamespaceFilter(XmlUtil.JSF_HTML_URIS)), 2);
    }
}

