/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.toolWindow.tree.nodes;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jsf.model.xml.managedBeans.ManagedProperty;
import com.intellij.jsf.model.xml.managedBeans.propertyValue.ValuableProperty;
import com.intellij.jsf.toolWindow.tree.nodes.JsfDomModelElementNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import icons.JsfIcons;

class JsfDomManagedPropertyNode
extends JsfDomModelElementNode<ManagedProperty> {
    private final ManagedProperty myManagedProperty;

    public JsfDomManagedPropertyNode(Project project, JsfDomModelElementNode parent, ManagedProperty managedProperty) {
        super(project, (NodeDescriptor)parent, managedProperty, JsfIcons.GenericValue);
        this.myManagedProperty = managedProperty;
    }

    @Override
    protected String getActualNodeName() {
        String name = this.myManagedProperty.getPropertyName().getStringValue();
        if (this.myManagedProperty instanceof ValuableProperty && !StringUtil.isEmptyOrSpaces((String)name)) {
            ValuableProperty property = (ValuableProperty)this.myManagedProperty;
            if (property.isNullValue()) {
                name = name + " = null";
            } else {
                String value = property.getValue().getStringValue();
                if (!StringUtil.isEmptyOrSpaces((String)value)) {
                    name = name + " = " + value;
                }
            }
        }
        return StringUtil.isEmptyOrSpaces((String)name) ? "" : name;
    }

    @Override
    protected String getNodeTextExt() {
        if (this.myManagedProperty instanceof ValuableProperty) {
            return ((ValuableProperty)this.myManagedProperty).getPropertyClass().getStringValue();
        }
        return super.getNodeTextExt();
    }
}

