/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.presentation;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.javascript.flex.presentation.FlexTreeStructureProvider;
import com.intellij.lang.javascript.flex.presentation.SwfProjectViewStructureProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SwfQualifiedNamedElementNode
extends ProjectViewNode<JSQualifiedNamedElement> {
    public SwfQualifiedNamedElementNode(Project project, JSQualifiedNamedElement element, ViewSettings settings) {
        super(project, (Object)element, settings);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/presentation/SwfQualifiedNamedElementNode", "contains"));
        }
        return SwfProjectViewStructureProvider.nodeContainsFile(this, file);
    }

    public boolean canRepresent(Object element) {
        JSQualifiedNamedElement value = (JSQualifiedNamedElement)this.getValue();
        return value != null && value.isValid() && element != null && value.getClass() == element.getClass() && Comparing.equal((String)value.getQualifiedName(), (String)((JSQualifiedNamedElement)element).getQualifiedName());
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList arrayList = new ArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/presentation/SwfQualifiedNamedElementNode", "getChildren"));
        }
        return arrayList;
    }

    protected void update(PresentationData presentation) {
        JSQualifiedNamedElement value = (JSQualifiedNamedElement)this.getValue();
        if (value != null && value.isValid()) {
            presentation.setPresentableText(value.getName());
            presentation.setIcon(value.getIcon(1));
        }
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        JSQualifiedNamedElement value = (JSQualifiedNamedElement)this.getValue();
        if (value != null && value.isValid()) {
            value.navigate(true);
        }
    }

    public int getTypeSortWeight(boolean sortByType) {
        int weight;
        if (sortByType && (weight = FlexTreeStructureProvider.getElementWeight((JSElement)this.getValue())) != -1) {
            return weight;
        }
        return super.getTypeSortWeight(sortByType);
    }
}

