/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.uml;

import com.intellij.diagram.AbstractUmlVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class FlashUmlVisibilityManager
extends AbstractUmlVisibilityManager {
    private static final List<VisibilityLevel> predefinedLevels = new ArrayList<VisibilityLevel>();
    private static final Comparator<VisibilityLevel> COMPARATOR;

    public VisibilityLevel[] getVisibilityLevels() {
        return predefinedLevels.toArray(new VisibilityLevel[predefinedLevels.size()]);
    }

    public VisibilityLevel getVisibilityLevel(Object element) {
        if (element instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
            JSAttributeList.AccessType accessType = attributeList != null ? attributeList.getAccessType() : JSUtils.getImplicitAccessType((PsiElement)((PsiElement)element));
            return predefinedLevels.get(ArrayUtil.indexOf((Object[])JSVisibilityUtil.ACCESS_TYPES, (Object)accessType));
        }
        return null;
    }

    public Comparator<VisibilityLevel> getComparator() {
        return COMPARATOR;
    }

    static {
        for (JSAttributeList.AccessType accessType : JSVisibilityUtil.ACCESS_TYPES) {
            predefinedLevels.add(new VisibilityLevel(accessType.name(), JSBundle.message((String)("javascript.uml.visibility." + accessType.name().toLowerCase()), (Object[])new Object[0])));
        }
        COMPARATOR = (o1, o2) -> {
            int ind2;
            int ind1 = predefinedLevels.indexOf(o1);
            return ind1 == (ind2 = predefinedLevels.indexOf(o2)) ? 0 : (ind1 < 0 ? 1 : ind1 - ind2);
        };
    }
}

