/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.util.CssStyleSheetElementType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StylesheetFileBase
extends PsiFileBase
implements StylesheetFile {
    protected StylesheetFileBase(@NotNull FileViewProvider viewProvider, @NotNull Language language) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/css/impl/StylesheetFileBase", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/css/impl/StylesheetFileBase", "<init>"));
        }
        super(viewProvider, language);
    }

    public String toString() {
        return "CssFile:" + this.getName();
    }

    public CssStylesheet getStylesheet() {
        FileElement treeElement = this.calcTreeElement();
        for (ASTNode e = treeElement.getFirstChildNode(); e != null; e = e.getTreeNext()) {
            IElementType type = e.getElementType();
            if (!(type instanceof CssStyleSheetElementType)) continue;
            return (CssStylesheet)SourceTreeToPsiMap.treeElementToPsi((ASTNode)e);
        }
        return null;
    }

    protected abstract CssStyleSheetElementType getStylesheetElementType();

    public boolean isImportVisibleInContext(CssImport anImport, @Nullable PsiElement context) {
        return true;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/StylesheetFileBase", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitStylesheetFile((StylesheetFile)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }
}

