/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.references;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.css.resolve.UrlReference;
import com.intellij.psi.css.resolve.impl.CssResolverImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.ultimate.UltimateVerifier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssResolveManagerImpl
extends CssResolveManager {
    public CssResolveManagerImpl(UltimateVerifier verifier) {
        PluginVerifier.verifyUltimatePlugin(verifier);
    }

    public CssResolver getNewResolver() {
        return new CssResolverImpl();
    }

    public CssDeclaration[] resolve(XmlTag tag, XmlFile[] xhtmlFiles, CssStylesheet defaultStylesheet) {
        CssResolverImpl resolver = new CssResolverImpl();
        if (defaultStylesheet != null) {
            resolver.setDefaultStylesheet(defaultStylesheet);
        }
        return resolver.resolve(tag, (PsiFile[])xhtmlFiles);
    }

    @NotNull
    public PsiFile[] resolveFiles(@Nullable PsiElement uriElement, @NotNull PsiFile base) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/psi/css/impl/util/references/CssResolveManagerImpl", "resolveFiles"));
        }
        if (uriElement instanceof CssUri) {
            uriElement = ((CssUri)uriElement).getValueElement();
        }
        if (uriElement == null) {
            if (PsiFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssResolveManagerImpl", "resolveFiles"));
            }
            return PsiFile.EMPTY_ARRAY;
        }
        ArrayList result = ContainerUtil.newArrayList();
        PsiReference[] references = uriElement.getReferences();
        if (references.length == 0) {
            references = CssResolveManagerImpl.getJspHackReferences(uriElement);
        }
        for (PsiReference reference : references) {
            if (reference instanceof FileReference) {
                if (!((FileReference)reference).isLast()) continue;
                for (ResolveResult resolveResult : ((FileReference)reference).multiResolve(false)) {
                    CssResolveManagerImpl.addStylesheetFile(result, resolveResult.getElement());
                }
                continue;
            }
            if (reference instanceof PsiDynaReference) {
                PsiFileReference fileReference = ((PsiDynaReference)reference).getLastFileReference();
                if (fileReference == null) continue;
                for (ResolveResult resolveResult : fileReference.multiResolve(false)) {
                    CssResolveManagerImpl.addStylesheetFile(result, resolveResult.getElement());
                }
                continue;
            }
            if (!(reference instanceof UrlReference)) continue;
            CssResolveManagerImpl.addStylesheetFile(result, reference.resolve());
        }
        PsiFile[] psiFileArray = !result.isEmpty() ? result.toArray(new PsiFile[result.size()]) : PsiFile.EMPTY_ARRAY;
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssResolveManagerImpl", "resolveFiles"));
        }
        return psiFileArray;
    }

    private static void addStylesheetFile(@NotNull Collection<PsiFile> result, @Nullable PsiElement element) {
        PsiFile stylesheetFile;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/references/CssResolveManagerImpl", "addStylesheetFile"));
        }
        if (element == null || !(element instanceof PsiFile)) {
            return;
        }
        if (!(element instanceof StylesheetFile) && (stylesheetFile = ((PsiFile)element).getViewProvider().getPsi((Language)CSSLanguage.INSTANCE)) instanceof StylesheetFile) {
            result.add(stylesheetFile);
            return;
        }
        result.add((PsiFile)element);
    }

    @NotNull
    private static PsiReference[] getJspHackReferences(@NotNull PsiElement element) {
        XmlAttributeValue valueElement;
        XmlAttribute[] attributes;
        PsiElement elementAt;
        XmlTag tag;
        String value;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/references/CssResolveManagerImpl", "getJspHackReferences"));
        }
        OuterLanguageElement childOfType = null;
        for (PsiElement sibling = element.getFirstChild(); sibling != null; sibling = sibling.getNextSibling()) {
            if (!(sibling instanceof OuterLanguageElement)) continue;
            childOfType = (OuterLanguageElement)sibling;
            break;
        }
        if (childOfType != null && (value = ElementManipulators.getValueText((PsiElement)element)).equals(childOfType.getText()) && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(elementAt = element.getContainingFile().findElementAt(childOfType.getTextOffset())), XmlTag.class)) != null && (attributes = tag.getAttributes()).length == 1 && !"http://java.sun.com/JSP/Page".equals(tag.getNamespace()) && CssResolveManagerImpl.isUrlDecoratingCustomTag(tag) && tag.getTextRange().equals((Object)childOfType.getTextRange()) && (valueElement = attributes[0].getValueElement()) != null) {
            PsiReference[] psiReferenceArray = valueElement.getReferences();
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssResolveManagerImpl", "getJspHackReferences"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssResolveManagerImpl", "getJspHackReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean isUrlDecoratingCustomTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/impl/util/references/CssResolveManagerImpl", "isUrlDecoratingCustomTag"));
        }
        String localName = tag.getLocalName();
        if ("url".equals(localName)) {
            return Arrays.binarySearch(XmlUtil.JSTL_CORE_URIS, tag.getNamespace()) >= 0;
        }
        return "rewrite".equals(localName) && "http://struts.apache.org/tags-html".equals(tag.getNamespace());
    }
}

