/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class CssInsertCommaAfterSelectorFix
extends LocalQuickFixOnPsiElement {
    public CssInsertCommaAfterSelectorFix(CssSimpleSelector simpleSelector) {
        super((PsiElement)simpleSelector);
    }

    @NotNull
    public String getText() {
        String string = CssBundle.message((String)"css.inspections.missing.comma.fix.message", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssInsertCommaAfterSelectorFix", "getText"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        CssSelectorList selectorList;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/CssInsertCommaAfterSelectorFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/inspections/CssInsertCommaAfterSelectorFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/psi/css/inspections/CssInsertCommaAfterSelectorFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/psi/css/inspections/CssInsertCommaAfterSelectorFix", "invoke"));
        }
        if (startElement.isValid() && startElement instanceof CssSimpleSelector && (selectorList = (CssSelectorList)PsiTreeUtil.getParentOfType((PsiElement)startElement, CssSelectorList.class)) != null && selectorList.isValid()) {
            StringBuilder selectorListText = new StringBuilder(selectorList.getText());
            selectorListText.insert(startElement.getTextRange().getEndOffset() - selectorList.getTextRange().getStartOffset(), ",");
            Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)startElement);
            selectorList.replace((PsiElement)CssElementFactory.getInstance((Project)project).createSelectorList(selectorListText.toString(), language));
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"css.inspections.missing.comma.fix.message", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssInsertCommaAfterSelectorFix", "getFamilyName"));
        }
        return string;
    }
}

